/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class CloseMethodDotNet extends MethodExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    public CloseMethodDotNet(final BlancoDbObjectStorageDotNet storage) {
        super("Close");
        this.storage = storage;
    }

    public void setupSignature() {
        getJavaDoc().addLine("pĂf[^x[X\[XJ܂B");
        getJavaDoc().addLine("NX̗pIۂɕK̃\bhĂяoĂB");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        implementor.addLine("if (fStatement != null) {");
        implementor.addLine("fStatement = null;");
        implementor.addLine("}");
    }
}