/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.definition.QueryIteratorDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetListMethodDotNet extends MethodExpander {

    private QueryIteratorDotNet _iterator = null;

    public GetListMethodDotNet(final QueryIteratorDotNet iterator) {
        super("GetList");
        _iterator = iterator;
    }

    public void setupSignature() {
        setReturnType(new IgType("System.Collections.ArrayList"));
        addArgument(new IgValue(new IgType("int"), "size"));
        addUsingType(new IgType("System.Collections.ArrayList"));

        getJavaDoc().addLine("ʂXgŎ擾܂B");
        getJavaDoc().addLine("Xgɂ " + _iterator.getName() + "NXi[܂B");

        getJavaDoc().addParameter("size", "ǂݏossB");
        getJavaDoc().addReturn(
                _iterator.getName() + "NXListBʂ0̏ꍇɂ͋̃XgB");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        implementor.addLine("ArrayList result = new ArrayList(size);");
        implementor.addLine("for (int count = 1; count <= size; count++) {");
        implementor.addLine("if (Next() == false) {");
        implementor.addLine("break;");
        implementor.addLine("}");
        implementor.addLine("result.Add(GetRow());");
        implementor.addLine("}");
        implementor.addLine("return result;");
    }
}