/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetResultSetMethodDotNet extends MethodExpander {
    private IgValue _resultSet = null;

    public GetResultSetMethodDotNet(final BlancoDbObjectStorageDotNet storage) {
        super("GetResultSet");
        _resultSet = new IgValue(new IgType(
                "System.Data.SqlClient.SqlDataReader"), "fResultSet");
    }

    public void setupSignature() {
        setReturnType(_resultSet.getType());

        getJavaDoc().addLine("ResultSet擾܂B");
        getJavaDoc().addLine("@deprecated {IResultSet𒼐ڗpKv͂܂B");
        getJavaDoc().addReturn("ResultSetIuWFNg");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        implementor.addReturn(_resultSet);
    }
}