/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.definition.QueryIteratorDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * Singletruȅꍇɂ̂݁ÃNX͗p܂
 * 
 * @author Tosiki Iga
 */
public class GetSingleRowMethodDotNet extends MethodExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    private String runtimePackage = null;

    private IgValue _result = null;

    public GetSingleRowMethodDotNet(final BlancoDbObjectStorageDotNet storage,
            final IgType rowObjectType, final QueryIteratorDotNet iterator) {
        super("GetSingleRow");
        this.storage = storage;

        runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        _result = new IgValue(rowObjectType, "result");
    }

    public void setupSignature() {
        setReturnType(_result.getType());

        final IgType noRowFoundException = new IgType(runtimePackage
                + ".exception.NoRowFoundException");
        addUsingType(noRowFoundException);
        final IgType tooManyRowsFoundException = new IgType(runtimePackage
                + ".exception.TooManyRowsFoundException");
        addUsingType(tooManyRowsFoundException);

        getJavaDoc().addLine("݂̍s̃f[^IuWFNgƂĎ擾܂B");
        getJavaDoc().addLine(
                "̃\bh𗘗pꍇɂ́ANext()Ȃǂ̃J[\𑀍삷郁\bhƂ͕pȂłB");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("singleL");
        getJavaDoc().addLine("ʂ1ȊȌꍇɂ́ANotSingleRowExceptionNX");
        getJavaDoc().addLine("hNX̗O܂B");
        getJavaDoc().addReturn("sIuWFNg");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        getData().addLine("if (Next() == false) {");
        getData().addLine("throw new NoRowFoundException(\"sł܂łB\");");
        getData().addLine("}");
        getData().addLine("");
        getData().addLine(_result.getType().getName() + " result = GetRow();");
        getData().addLine("");
        getData().addLine("if (Next()) {");
        getData().addLine(
                "throw new TooManyRowsFoundException(\"1ȏ̍s܂B\");");
        getData().addLine("}");
        getData().addLine("");
        getData().addLine("return result;");
    }
}