/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import blanco.db.conf.BlancoDbSettingDotNet;
import blanco.ig.expander.IgType;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbObjectStorageDotNet {
    private BlancoDbSettingDotNet _setting = null;

    public BlancoDbSettingDotNet getSetting() {
        return _setting;
    }

    public void setSetting(final BlancoDbSettingDotNet setting) {
        _setting = setting;
    }

    /**
     * pbP[W̓ǑւsȂTypeNX̃CX^X𐶐܂B
     * 
     * @param type
     * @return
     */
    public IgType createRuntime(final Class type) {
        String typeName = type.getName().replaceAll("blanco.db",
                _setting.getRootNameSpace());
        return new IgType(typeName);
    }
}