/*
 * blanco Framework
 * Copyright (C) 2004-2006 WATANABE Yoshinori
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.sql.format;

import java.util.ArrayList;

/**
 * BlancoSqlFormatter: SQL`c[. SQL߂ꂽ[ɏ]`܂B <br>
 * SQLƂĐƂOłB
 * http://homepage2.nifty.com/igat/igapyon/diary/2005/ig050613.html
 * SQL͂镔łB<br>
 * 2005.08.12 Tosiki Iga: ̃[eBeB\bh public static܂B<br>
 * 2005.08.12 Tosiki Iga: 65535(Ƃ-1)̓zCgXy[XƂĈ悤ύX܂B
 * 
 * @author WATANABE Yoshinori (a-san) : original version at 2005.07.04.
 * @author IGA Tosiki : marge into blanc Framework at 2005.07.04
 */
public class BlancoSqlParser {

    /** ͑O̕. */
    String before;

    /** ͒̕. */
    char ch;

    /** ͒̈ʒu. */
    int pos;

    /** Q̋L */
    // 2005.07.26 Tosiki Iga 񌋍 || ǉ܂B
    String[] twoCharacterSymbol = { "<>", "<=", ">=", "||" };

    BlancoSqlParser() {
    }

    /**
     * zCgXy[Xǂ<br>
     * 2005.08.12 Tosiki Iga: \bh public static܂B
     */
    public static boolean isSpace(char c) {
        // 2005.07.26 Tosiki Iga \r ͈͂Ɋ܂߂Kv܂B
        // 2005.08.12 Tosiki Iga 65535(Ƃ-1)̓zCgXy[XƂĈ悤ύX܂B
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == 65535;
    }

    /**
     * ƂĔFĂǂ<br>
     * SpȂǂƂĔFêƔf܂<br>
     * 2005.08.12 Tosiki Iga: \bh public static܂B<br>
     * ̃\bhBlancoSqlEditorPluginQƂ܂B
     */
    public static boolean isLetter(char c) {
        // SQLɂ A_[XRA͉p̒Ԃł.
        // blanco ɂ # ͉p̒Ԃł.
        // ɓ{܂߂ȂĂ͂ȂȂB
        // return ('A' <= c && c <= 'Z') || ('a' <= c && c <= 'z')
        // || (c == '_' || c == '#');
        if (isSpace(c)) {
            return false;
        }
        if (isDigit(c)) {
            return false;
        }
        if (isSymbol(c)) {
            return false;
        }
        return true;
    }

    /**
     * ǂ<br>
     * 2005.08.12 Tosiki Iga: \bh public static܂B
     */
    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    /**
     * Lǂ𔻒肵܂B<br>
     * 2005.08.12 Tosiki Iga: \bh public static܂B
     */
    public static boolean isSymbol(char c) {
        switch (c) {
        case '"': // double quote
        case '?': // question mark
        case '%': // percent
        case '&': // ampersand
        case '\'': // quote
        case '(': // left paren
        case ')': // right paren
        case '|': // vertical bar
        case '*': // asterisk
        case '+': // plus sign
        case ',': // comma
        case '-': // minus sign
        case '.': // period
        case '/': // solidus
        case ':': // colon
        case ';': // semicolon
        case '<': // less than operator
        case '=': // equals operator
        case '>': // greater than operator

            // blancoł # ͕̈ꕔł case '#':
            // A_[XRA͋LƂ͈܂ case '_': //underscore
            // ȍ~͕̈ۗ̕
            // case '!':
            // case '$':
            // case '[':
            // case '\\':
            // case ']':
            // case '^':
            // case '{':
            // case '}':
            // case '~':
            return true;
        default:
            return false;
        }
    }

    /**
     * g[Nɐi߂. posi߂BsɌʂԂBtypeɂ̎ނݒ肷B sSQL̏ꍇAO܂B
     * @`FbN͍sĂ܂B
     * 
     * @return g[NԂ.
     */
    BlancoSqlToken nextToken() {
        if (pos >= before.length()) {
            pos++;
            return new BlancoSqlToken(BlancoSqlToken.END, "");
        }
        ch = before.charAt(pos);
        // System.out.println("ch="+((int)ch));
        if (isSpace(ch)) {
            String s = "";
            for (;;) {
                s += ch;
                ch = before.charAt(pos);
                if (!isSpace(ch))
                    return new BlancoSqlToken(BlancoSqlToken.SPACE, s);
                pos++;
                if (pos >= before.length())
                    return new BlancoSqlToken(BlancoSqlToken.SPACE, s);
            }
        } else if (ch == ';') {
            pos++;
            // 2005.07.26 Tosiki Iga Z~R͏Ił͂Ȃ悤ɂB
            return new BlancoSqlToken(BlancoSqlToken.SYMBOL, ";");
        } else if (isDigit(ch)) {
            String s = "";
            while (isDigit(ch) || ch == '.') {
                // if (ch == '.') type = Token.REAL;
                s += ch;
                pos++;

                if (pos >= before.length()) {
                    // 𒴂Ăꍇɂ͏f܂B
                    break;
                }

                ch = before.charAt(pos);
            }
            return new BlancoSqlToken(BlancoSqlToken.VALUE, s);
        } else if (isLetter(ch)) {
            String s = "";
            // 񒆂̃hbgɂẮAƈ̂ƂčlB
            while (isLetter(ch) || isDigit(ch) || ch == '.') {
                s += ch;
                pos++;
                if (pos >= before.length()) {
                    break;
                }

                ch = before.charAt(pos);
            }
            for (int i = 0; i < BlancoSqlConstants.SQL_RESERVED_WORDS.length; i++) {
                if (s
                        .compareToIgnoreCase(BlancoSqlConstants.SQL_RESERVED_WORDS[i]) == 0) {
                    return new BlancoSqlToken(BlancoSqlToken.KEYWORD, s);
                }
            }
            return new BlancoSqlToken(BlancoSqlToken.NAME, s);
        }
        // single line comment
        else if (ch == '-') {
            pos++;
            char ch2 = before.charAt(pos);
            // -- ȂƂ
            if (ch2 != '-') {
                return new BlancoSqlToken(BlancoSqlToken.SYMBOL, "-");
            }
            pos++;
            String s = "--";
            for (;;) {
                ch = before.charAt(pos);
                s += ch;
                pos++;
                if (ch == '\n')
                    return new BlancoSqlToken(BlancoSqlToken.COMMENT, s);
            }
        }
        // }`CRg
        else if (ch == '/') {
            pos++;
            char ch2 = before.charAt(pos);
            // /* ȂƂ
            if (ch2 != '*') {
                return new BlancoSqlToken(BlancoSqlToken.SYMBOL, "/");
            }
            String s = "/*";
            pos++;
            int ch0 = -1;
            for (;;) {
                ch0 = ch;
                ch = before.charAt(pos);
                s += ch;
                pos++;
                if (ch0 == '*' && ch == '/')
                    return new BlancoSqlToken(BlancoSqlToken.COMMENT, s);
            }
        } else if (ch == '\'') {
            pos++;
            String s = "'";
            for (;;) {
                ch = before.charAt(pos);
                s += ch;
                pos++;
                if (ch == '\'')
                    return new BlancoSqlToken(BlancoSqlToken.VALUE, s);
            }
        } else if (ch == '\"') {
            pos++;
            String s = "\"";
            for (;;) {
                ch = before.charAt(pos);
                s += ch;
                pos++;
                if (ch == '\"')
                    return new BlancoSqlToken(BlancoSqlToken.NAME, s);
            }
        }

        else if (isSymbol(ch)) {
            // L
            String s = "" + ch;
            pos++;
            if (pos >= before.length())
                return new BlancoSqlToken(BlancoSqlToken.SYMBOL, s);
            // Q̋Lǂׂ
            char ch2 = before.charAt(pos);
            for (int i = 0; i < twoCharacterSymbol.length; i++) {
                if (twoCharacterSymbol[i].charAt(0) == ch
                        && twoCharacterSymbol[i].charAt(1) == ch2) {
                    pos++;
                    s += ch2;
                    break;
                }
            }
            return new BlancoSqlToken(BlancoSqlToken.SYMBOL, s);
        } else {
            pos++;
            return new BlancoSqlToken(BlancoSqlToken.UNKNOWN, "" + ch);
        }
    }

    /**
     * SQLg[N̔zɕϊ܂B
     * 
     * @param before
     *            ϊOSQL
     * @return Token̔z
     */
    ArrayList parse(String before) {
        this.pos = 0;
        this.before = before;
        ArrayList list = new ArrayList();
        for (;;) {
            BlancoSqlToken t = nextToken();
            if (t.type == BlancoSqlToken.END)
                break;
            list.add(t);
        }
        return list;
    }

}
