/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.util.ArrayList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.db.util.BlancoDbQueryParserUtilDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class GetQueryMethodDotNet extends MethodExpander {
    private String _query = "";

    public GetQueryMethodDotNet(final String query) {
        super("GetQuery");
        _query = query;
    }

    public void setupSignature() {
        // getQuerypublicɕύXB
        addUsingType(new IgType("System.String"));
        setReturnType(new IgType("string"));

        addUsingType(new IgType("System.Text.StringBuilder"));

        getJavaDoc().addLine("NG̎擾\bh");
        getJavaDoc().addLine("ۂɎsSQL߂܂B");
        getJavaDoc().addReturn("ۂɎsSQL");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        // 2005.04.15 t.iga s͉sƂďo͂悤ɕύXB
        // 2005.10.12 t.iga blancoCommons̕ϊ[eBeB𗘗p悤ɕύXB
        final String escapedQuery = BlancoJavaSourceUtil
                .escapeStringAsJavaSource(_query);

        // NG #p[^?ւ̕ϊB
        final String actualSql = new BlancoDbQueryParserUtilDotNet(escapedQuery)
                .getNaturalSqlStringForDotNet();

        // SQLs̕ŕf܂B
        final String[] sqlLines = splitString(actualSql, "\\n");

        implementor.addLine("StringBuilder builder = new StringBuilder();");
        for (int index = 0; index < sqlLines.length; index++) {
            if (index == 0) {
                implementor.addLine("builder.Append(\"" + sqlLines[index]
                        + "\");");
            } else {
                implementor.addLine("builder.Append(\"" + sqlLines[index]
                        + "\");");
            }
        }

        implementor.addLine("return builder.ToString();");
    }

    /**
     * ^ꂽw̕ĕ܂B
     * 
     * APIł́A͕񂩂Ď镶͂܂B<br>
     * ʊ֐̌API
     * 
     * @param originalString
     * @param delimiterString
     * @return
     */
    public static String[] splitString(final String originalString,
            final String delimiterString) {
        final ArrayList result = new ArrayList();
        String nextString = originalString;

        for (;;) {
            if (nextString.length() == 0) {
                break;
            }
            final int find = nextString.indexOf(delimiterString);
            if (find >= 0
                    && find + delimiterString.length() <= nextString.length()) {
                final String item = nextString.substring(0, find
                        + delimiterString.length());
                result.add(item);
                nextString = nextString.substring(find
                        + delimiterString.length());
            } else {
                result.add(nextString);
                break;
            }
        }

        final String[] resultStringArray = new String[result.size()];
        result.toArray(resultStringArray);
        return resultStringArray;
    }

}