/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.util;

import blanco.cg.BlancoCgSupportedLang;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoPhpSourceUtil;
import blanco.commons.util.BlancoVbSourceUtil;

/**
 * blancoCg̃\[XR[h֘A[eBeBłB
 * 
 * ̃NX̓vO~O𒴂ėp܂B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoCgSourceUtil {
    /**
     * ^ꂽ\[XR[hƂďo͂̂ƂăGXP[v܂B
     * 
     * /obNXbṼGXP[vщsR[h̃GXP[vs܂B<br>
     * ȊȌ͍s܂BƂ΃CWFNVUȂǂւ̑ϐ́Ã\bh͈܂B
     * 
     * @param targetLang
     *            o͑ΏۂƂȂvO~OB
     * @param originalString
     *            ͕B
     * @return GXP[vsꂽ̕
     */
    public static String escapeStringAsSource(final int targetLang,
            final String originalString) {
        switch (targetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
            return BlancoJavaSourceUtil
                    .escapeStringAsJavaSource(originalString);
        case BlancoCgSupportedLang.VB:
            return BlancoVbSourceUtil.escapeStringAsVbSource(originalString);
        case BlancoCgSupportedLang.PHP:
            return BlancoPhpSourceUtil.escapeStringAsPhpSource(originalString);
        default:
            throw new IllegalArgumentException(
                    "BlancoCgSourceUtil.escapeAsSourceString ɃT|[gȂ("
                            + targetLang + ")Ƃė^܂B");
        }
    }

    /**
     * ^ꂽhLgƂĈƂł̂ւƃGXP[v܂B JavaDocƂăGXP[vs܂B
     * 
     * HTMLƂẴGXP[vƓ̏s܂BhGXP[v܂B
     * 
     * @param targetLang
     *            o͑ΏۂƂȂvO~OB
     * @param originalString
     *            ͕
     * @return GXP[vsꂽ̕
     */
    public static final String escapeStringAsLangDoc(final int targetLang,
            final String originalString) {
        switch (targetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.PHP:
            return BlancoJavaSourceUtil.escapeStringAsJavaDoc(originalString);
        default:
            throw new IllegalArgumentException(
                    "BlancoCgSourceUtil.escapeStringAsLangDoc ɃT|[gȂ("
                            + targetLang + ")Ƃė^܂B");
        }
    }
}