/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */

/**
 * ftHgRXgN^
 * @fileoverview ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * @class O[ṽTvB̃NX͒PɃTvłBۂ̓ɂ͗p܂B
 * @constructor
 */
function SampleStringGroup() {
    /* p[^̐A^`FbNs܂B */
    if (arguments.length !== 0) {
        throw new Error("[ArgumentException]: SampleStringGroup.SampleStringGroup ̃p[^[0]łKv܂Bۂɂ[" + arguments.length +  "]̃p[^𔺂ČĂяo܂B");
    }

}

/**
 * No.1 :At@xbg̕`B
 * @type int
 */
SampleStringGroup.ABCDEFG = 1;

/**
 * No.2 :Sp̕`B
 * @type int
 */
SampleStringGroup.AIUEO = 2;

/**
 * No.3 :VONI[gWJ邱Ƃ̊mFB
 * @type int
 */
SampleStringGroup.QUOTE = 3;

/**
 * No.4 :_uNI[gWJ邱Ƃ̊mFB
 * @type int
 */
SampleStringGroup.DOUBLE_QUOTE = 4;

/**
 * No.5 :obNXbVWJ邱Ƃ̊mFB
 * @type int
 */
SampleStringGroup.BACK_SLASH = 5;

/**
 * No.7
 * @type int
 */
SampleStringGroup.WITHOUT_DESC = 7;

/**
 * No.8 :r̋󔒂K؂ɏ邱Ƃ̊mFB
 * @type int
 */
SampleStringGroup.TEST_SPACE = 8;

/**
 * `BO[vȊO̕܂͒萔`̂́B
 * @type int
 */
SampleStringGroup.NOT_DEFINED = -1;

/**
 * O[vɊ܂܂镶ł邩ǂ𔻒肵܂B
 * @addon
 * @param {string} argCheck `FbNsB
 * @return O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB
 * @type boolean
 */
SampleStringGroup.prototype.match = function(/* string */ argCheck) {
    /* p[^̐A^`FbNs܂B */
    if (arguments.length !== 1) {
        throw new Error("[ArgumentException]: SampleStringGroup.match ̃p[^[1]łKv܂Bۂɂ[" + arguments.length +  "]̃p[^𔺂ČĂяo܂B");
    }
    if (typeof(argCheck) != "string") {
        throw new Error("[ArgumentException]: SampleStringGroup.match 1Ԗڂ̃p[^[string]^łȂĂ͂Ȃ܂Bۂɂ[" + typeof(argCheck) + "]^^܂B");
    }

    // No.1
    // :At@xbg̕`B
    if ("ABCDEFG" == argCheck) {
        return true;
    }
    // No.2
    // :Sp̕`B
    if ("" == argCheck) {
        return true;
    }
    // No.3
    // :VONI[gWJ邱Ƃ̊mFB
    if ("'" == argCheck) {
        return true;
    }
    // No.4
    // :_uNI[gWJ邱Ƃ̊mFB
    if ("\"" == argCheck) {
        return true;
    }
    // No.5
    // :obNXbVWJ邱Ƃ̊mFB
    if ("\\" == argCheck) {
        return true;
    }
    // No.6
    // :萔ȗꂽ`B
    if ("STRING ONLY" == argCheck) {
        return true;
    }
    // No.7
    if ("ȗ" == argCheck) {
        return true;
    }
    // No.8
    // :r̋󔒂K؂ɏ邱Ƃ̊mFB
    if ("ABC DEF" == argCheck) {
        return true;
    }
    return false;
};

/**
 * O[vɊ܂܂镶ł邩ǂA啶ʂ肵܂B
 * @addon
 * @param {string} argCheck `FbNsB
 * @return O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB
 * @type boolean
 */
SampleStringGroup.prototype.matchIgnoreCase = function(/* string */ argCheck) {
    /* p[^̐A^`FbNs܂B */
    if (arguments.length !== 1) {
        throw new Error("[ArgumentException]: SampleStringGroup.matchIgnoreCase ̃p[^[1]łKv܂Bۂɂ[" + arguments.length +  "]̃p[^𔺂ČĂяo܂B");
    }
    if (typeof(argCheck) != "string") {
        throw new Error("[ArgumentException]: SampleStringGroup.matchIgnoreCase 1Ԗڂ̃p[^[string]^łȂĂ͂Ȃ܂Bۂɂ[" + typeof(argCheck) + "]^^܂B");
    }

    // No.1
    // :At@xbg̕`B
    if ("ABCDEFG".toUpperCase() == argCheck.toUpperCase()) {
        return true;
    }
    // No.2
    // :Sp̕`B
    if ("".toUpperCase() == argCheck.toUpperCase()) {
        return true;
    }
    // No.3
    // :VONI[gWJ邱Ƃ̊mFB
    if ("'".toUpperCase() == argCheck.toUpperCase()) {
        return true;
    }
    // No.4
    // :_uNI[gWJ邱Ƃ̊mFB
    if ("\"".toUpperCase() == argCheck.toUpperCase()) {
        return true;
    }
    // No.5
    // :obNXbVWJ邱Ƃ̊mFB
    if ("\\".toUpperCase() == argCheck.toUpperCase()) {
        return true;
    }
    // No.6
    // :萔ȗꂽ`B
    if ("STRING ONLY".toUpperCase() == argCheck.toUpperCase()) {
        return true;
    }
    // No.7
    if ("ȗ".toUpperCase() == argCheck.toUpperCase()) {
        return true;
    }
    // No.8
    // :r̋󔒂K؂ɏ邱Ƃ̊mFB
    if ("ABC DEF".toUpperCase() == argCheck.toUpperCase()) {
        return true;
    }
    return false;
};

/**
 * 񂩂萔ɕϊ܂B
 * @addon
 * @param {string} argCheck ϊsB
 * @return 萔ɕϊ̒lB
 * @type int
 * 萔`̏ꍇ ^ꂽ񂪕O[vȌꍇɂ NOT_DEFINED ߂܂B
 */
SampleStringGroup.prototype.convertToInt = function(/* string */ argCheck) {
    /* p[^̐A^`FbNs܂B */
    if (arguments.length !== 1) {
        throw new Error("[ArgumentException]: SampleStringGroup.convertToInt ̃p[^[1]łKv܂Bۂɂ[" + arguments.length +  "]̃p[^𔺂ČĂяo܂B");
    }
    if (typeof(argCheck) != "string") {
        throw new Error("[ArgumentException]: SampleStringGroup.convertToInt 1Ԗڂ̃p[^[string]^łȂĂ͂Ȃ܂Bۂɂ[" + typeof(argCheck) + "]^^܂B");
    }

    // No.1
    // :At@xbg̕`B
    if ("ABCDEFG" == argCheck) {
        return SampleStringGroup.ABCDEFG;
    }
    // No.2
    // :Sp̕`B
    if ("" == argCheck) {
        return SampleStringGroup.AIUEO;
    }
    // No.3
    // :VONI[gWJ邱Ƃ̊mFB
    if ("'" == argCheck) {
        return SampleStringGroup.QUOTE;
    }
    // No.4
    // :_uNI[gWJ邱Ƃ̊mFB
    if ("\"" == argCheck) {
        return SampleStringGroup.DOUBLE_QUOTE;
    }
    // No.5
    // :obNXbVWJ邱Ƃ̊mFB
    if ("\\" == argCheck) {
        return SampleStringGroup.BACK_SLASH;
    }
    // No.7
    if ("ȗ" == argCheck) {
        return SampleStringGroup.WITHOUT_DESC;
    }
    // No.8
    // :r̋󔒂K؂ɏ邱Ƃ̊mFB
    if ("ABC DEF" == argCheck) {
        return SampleStringGroup.TEST_SPACE;
    }

    // Y萔܂łB
    return SampleStringGroup.NOT_DEFINED;
};
/* NX[SampleStringGroup]錾̏IB */
