/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * EclipsevOC [BlancoSOAP]̃EBU[hNX
 */
package blanco.plugin.soap.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

import blanco.plugin.soap.BlancoSOAPPluginConstants;

/**
 * EclipsevOC [BlancoSOAP]̃EBU[hNXB
 *
 * blancoCsvvOC̃\[XR[ĥ߂̒`łB<br>
 */
public abstract class AbstractBlancoSOAPWizard extends Wizard implements INewWizard {
    /**
     */
    private ISelection selection;

    /**
     */
    public AbstractBlancoSOAPWizard() {
        super();
        setNeedsProgressMonitor(true);
        setWindowTitle("blancoSOAP Wizard");
    }

    /**
     *
     * @param workbench
     * @param selection
     */
    public void init(final IWorkbench workbench, final IStructuredSelection selection) {
        this.selection = selection;
    }

    /**
     *
     * @return
     */
    public boolean performFinish() {
        // {IɃ`FbN̓EBU[hŏIĂƉ肵܂B
        IProject proj = getProject(selection);
        if (proj == null) {
            return false;
        }

        //  t@CVK쐬܂B
        IFile file = proj.getFile(BlancoSOAPPluginConstants.TARGET_FILENAME);
        doFinish(file);

        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            // GfB^J܂B
            IDE.openEditor(page, file, "blanco.plugin.soap.editors");
        } catch (PartInitException e) {
            // O͖܂B
        }

        return true;
    }

    /**
     */
    public void addPages() {
        final AbstractBlancoSOAPWizardPage page = new BlancoSOAPWizardPage(selection);
        addPage(page);
        final BlancoSOAPWizardPage2 page2 = new BlancoSOAPWizardPage2(selection);
        addPage(page2);
        final BlancoSOAPWizardPage3 page3 = new BlancoSOAPWizardPage3(selection);
        addPage(page3);
        final BlancoSOAPWizardPage4 page4 = new BlancoSOAPWizardPage4(selection);
        addPage(page4);
        final AbstractBlancoSOAPWizardPage99 page99 = new BlancoSOAPWizardPage99(selection);
        addPage(page99);
    }

    /**
     * ISelection IProject(vWFNg)擾܂B
     *
     * @param selection
     * @return
     */
    public static IProject getProject(final ISelection selection) {
        IProject proj = null;
        IStructuredSelection ssel = (IStructuredSelection) selection;
        if (ssel.isEmpty()) {
            return null;
        }
        Object obj = ssel.getFirstElement();
        if (obj instanceof IProjectNature) {
            // vWFNg̏ꍇɂ́AꂪĂ܂B
            IProjectNature nature = (IProjectNature) obj;
            proj = nature.getProject();
        } else if (obj instanceof IResource) {
            IResource res = (IResource) obj;
            proj = res.getProject();
        } else {
            System.out.println(obj.getClass());
            return null;
        }
        return proj;
    }

    /**
     *
     * @param file
     */
    private void doFinish(final IFile file) {
        try {
            InputStream stream = openContentStream();
            if (file.exists()) {
                // Ȃɂ܂B
            } else {
                file.create(stream, false, null);
            }
            stream.close();
        } catch (IOException e) {
        } catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /**
     *
     * @return
     */
    private InputStream openContentStream() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><blanco/>";
        return new ByteArrayInputStream(contents.getBytes());
    }
}
