/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xsd.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.SAXException;

import blanco.commons.io.File2StreamWrapper;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.xsd.BlancoXsdTypeMapping;
import blanco.xsd.concretesax.BlancoXsdHandler;
import blanco.xsd.resourcebundle.BlancoXsdResourceBundle;

/**
 * ^ꂽXSDt@Cp[Xď擾܂B
 * 
 * ̃vO blancoWsdloRĐꂽXSDt@C̓ǂݍ݂ɂ̂ݑΉ܂B<br>
 * ėpIXSDp[TƂĂ͎ĂȂ_ɒӂB
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdParser {
    /**
     * fobO[hœ삳邩ǂB
     */
    private static final boolean IS_DEBUG = false;

    /**
     * \[XohIuWFNgB
     */
    private final BlancoXsdResourceBundle bundle = new BlancoXsdResourceBundle();

    /**
     * ̉ߒŒm蓾SĂ̌^
     */
    private final LinkedHashMap fAllKnownTypesHashMap = new LinkedHashMap();

    /**
     * ̉ߒŒm蓾SĂ̌^߂܂B
     * 
     * @return SĂ̌^̃Xg
     */
    public LinkedHashMap getAllKnownTypes() {
        return fAllKnownTypesHashMap;
    }

    /**
     * XSDt@Cp[X܂B
     * 
     * @param fileSource
     *            ̓t@C
     * @param targetName
     *            s^̖O
     * @return RvbNX^̏
     * @throws Exception
     *             Oꍇ
     */
    public ComplexTypeStructure process(final File fileSource,
            final String targetName) throws Exception {
        // Ci[NX̃\bh ̃NX̂QƂ邽߂finalϐ𗘗p܂B
        // ̋Lq͕KvȂ̂łB폜ȂłB
        final BlancoXsdParser parser = this;

        // Ci[NX̃\bh̖߂li[邽߂ɁA1̔z쐬܂B
        // ̋Lq͕KvȂ̂łB폜ȂłB
        final ComplexTypeStructure[] result = new ComplexTypeStructure[1];
        new File2StreamWrapper(fileSource, null) {
            protected void process(final InputStream inStream,
                    final OutputStream outStreamIgnore) throws IOException,
                    TransformerException, SAXException {
                result[0] = parser.process(inStream, targetName);
            }
        }.run();
        return result[0];
    }

    /**
     * XSDt@C̃Xg[p[XăRvbNX^̏擾܂B
     * 
     * @param inStream
     *            ̓Xg[
     * @param targetName
     *            ͂s^
     * @return ͂̌ʓRvbNX^̏
     * @throws IOException
     *             o͗Oꍇ
     * @throws TransformerException
     *             XMLϊOꍇ
     * @throws SAXException
     *             SAXOꍇ
     */
    public ComplexTypeStructure process(final InputStream inStream,
            final String targetName) throws IOException, TransformerException,
            SAXException {
        if (targetName == null) {
            throw new IllegalArgumentException(bundle.getXsdParserErr001());
        }

        final SAXResult result = new SAXResult();
        result.setHandler(new BlancoXsdHandler() {
            /**
             * RvbNX^̏ł邩ǂB
             */
            private boolean isInComplexType = false;

            /**
             * ^[Qbg̖OԁB
             */
            private String targetNamespace = null;

            /**
             * pbP[WBXSDannotationɎw肪ꍇɂ̂݊i[B
             */
            private String targetPackage = null;

            /**
             * Vv^L邽߂̕ϐB
             */
            private SimpleTypeStructure simpleTypeStructure;

            /**
             * RvbNX^L邽߂̕ϐB
             */
            private ComplexTypeStructure complexTypeStructure;

            // R[obN\bh JavaDoct^ƂĉǐቺƔf܂B

            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void startElementXsdSchema(String uri, String localName,
                    String qName, String attrXmlnsXsd, String attrXmlnsTns,
                    String attrXmlnsJxb, String attrTargetNamespace,
                    String attrElementFormDefault) throws SAXException {
                // OԂL܂B
                targetNamespace = attrTargetNamespace;

                // o͐pbP[W܂B
                targetPackage = null;
            }

            public void endElementXsdSchema(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdSchema(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSchema(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdSimpleType(String uri, String localName,
                    String qName, String attrName) throws SAXException {
                // Vv^`Jnꂽ̂ŁAϐ܂B
                simpleTypeStructure = new SimpleTypeStructure();
                simpleTypeStructure.setName(attrName);
                simpleTypeStructure.setTargetNamespace(targetNamespace);
            }

            public void endElementXsdSimpleType(String uri, String localName,
                    String qName) throws SAXException {
                if (IS_DEBUG) {
                    System.out.println("Vv^[" + "tns:"
                            + simpleTypeStructure.getName() + "]o^");
                }
                // Vv^`m肳ꂽ̂ŁAL܂B
                fAllKnownTypesHashMap.put("tns:"
                        + simpleTypeStructure.getName(), simpleTypeStructure);
            }

            public void charactersXsdSimpleType(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSimpleType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdRestriction(String uri,
                    String localName, String qName, String attrBase)
                    throws SAXException {
                // restriction SimpleTypê݂ŗLłƑO񂵂܂B
                simpleTypeStructure.setTypeOfNamespace(attrBase);

                final Object objFind = fAllKnownTypesHashMap.get(attrBase);
                if (objFind instanceof SimpleTypeStructure) {
                    final SimpleTypeStructure look = (SimpleTypeStructure) objFind;
                    simpleTypeStructure.setBaseRestriction(look);
                    simpleTypeStructure.setTypeOfJava(look.getTypeOfJava());
                } else {
                    // łȂxsd̊{^ł͂łB
                    final String typeFind = BlancoXsdTypeMapping
                            .xsdType2JavaType(attrBase, "1");
                    if (typeFind == null) {
                        throw new IllegalArgumentException("͂܂B");
                    }
                    simpleTypeStructure.setTypeOfJava(typeFind);
                }
            }

            public void endElementXsdRestriction(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdRestriction(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdRestriction(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMinLength(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
                if (isInComplexType) {
                    // RvbNX^łꍇɂ́Aɏ͍s܂B
                } else {
                    simpleTypeStructure.setMinLength(attrValue);
                }
            }

            public void endElementXsdMinLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMinLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdMinLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMaxLength(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
                if (isInComplexType) {
                    // RvbNX^łꍇɂ́Aɏ͍s܂B
                } else {
                    simpleTypeStructure.setMaxLength(attrValue);
                }
            }

            public void endElementXsdMaxLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMaxLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdMaxLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdPattern(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
                if (isInComplexType) {
                    // RvbNX^łꍇɂ́Aɏ͍s܂B
                } else {
                    simpleTypeStructure.setPattern(attrValue);
                }
            }

            public void endElementXsdPattern(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdPattern(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdPattern(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMinInclusive(String uri,
                    String localName, String qName, String attrValue)
                    throws SAXException {
                if (isInComplexType) {
                    // RvbNX^łꍇɂ́Aɏ͍s܂B
                } else {
                    simpleTypeStructure.setMinInclusive(attrValue);
                }
            }

            public void endElementXsdMinInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMinInclusive(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdMinInclusive(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementXsdMaxInclusive(String uri,
                    String localName, String qName, String attrValue)
                    throws SAXException {
                if (isInComplexType) {
                    // RvbNX^łꍇɂ́Aɏ͍s܂B
                } else {
                    simpleTypeStructure.setMaxInclusive(attrValue);
                }
            }

            public void endElementXsdMaxInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMaxInclusive(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdMaxInclusive(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementXsdLength(String uri, String localName,
                    String qName, String attrValue, String attrFixed)
                    throws SAXException {
                if (isInComplexType) {
                    // RvbNX^łꍇɂ́Aɏ͍s܂B
                } else {
                    simpleTypeStructure.setMinLength(attrValue);
                    simpleTypeStructure.setMaxLength(attrValue);
                }
            }

            public void endElementXsdLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdComplexType(String uri,
                    String localName, String qName, String attrName)
                    throws SAXException {
                isInComplexType = true;

                // RvbNX^`Jnꂽ̂ŁAϐ܂B
                complexTypeStructure = new ComplexTypeStructure();
                complexTypeStructure.setName(attrName);
                complexTypeStructure.setTypeOfNamespace("tns:"
                        + complexTypeStructure.getName());
                complexTypeStructure.setTargetNamespace(targetNamespace);

                // pbP[Wm肵܂B
                if (BlancoStringUtil.null2Blank(targetPackage).length() == 0) {
                    // XSDannotationɃpbP[Ww肪Ȃꍇɂ́AOԂ疼Oό`ăpbP[WmB
                    complexTypeStructure.setPackageOfJava(BlancoNameUtil
                            .uri2JavaPackage(targetNamespace));
                } else {
                    // XSDannotationɃpbP[Ww肪ꍇɂ́A̗pB
                    complexTypeStructure.setPackageOfJava(targetPackage);
                }

                complexTypeStructure.setTypeOfJava(complexTypeStructure
                        .getPackageOfJava()
                        + "." + BlancoNameAdjuster.toClassName(attrName));
            }

            public void endElementXsdComplexType(String uri, String localName,
                    String qName) throws SAXException {
                isInComplexType = false;

                if (IS_DEBUG) {
                    System.out.println("RvbNX^[" + "tns:"
                            + complexTypeStructure.getName() + "]o^");
                }
                // RvbNX^`m肵̂ŁAL܂B
                fAllKnownTypesHashMap.put("tns:"
                        + complexTypeStructure.getName(), complexTypeStructure);
            }

            public void charactersXsdComplexType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdComplexType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdSequence(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementXsdSequence(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdSequence(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSequence(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdElement(String uri,
                    final String localName, String qName, String attrName,
                    String attrType, String attrMinOccurs, String attrMaxOccurs)
                    throws SAXException {
                final String type = BlancoXsdTypeMapping.xsdType2JavaType(
                        attrType, attrMinOccurs);
                if (type != null) {
                    // PJavǎ^Ƀ}bsOł܂B
                    final JavaTypeStructure javaTypeStructure = new JavaTypeStructure();
                    javaTypeStructure.setName(attrName);
                    javaTypeStructure.setTypeOfJava(type);
                    // OԂ̓Zbg܂B
                    javaTypeStructure.setTypeOfNamespace(attrType);
                    if (isInComplexType) {
                        complexTypeStructure.getListField().add(
                                new ComplexTypeFieldStructure(
                                        javaTypeStructure, attrName,
                                        attrMinOccurs, attrMaxOccurs));
                    } else {
                        throw new IllegalArgumentException(bundle
                                .getXsdParserErr002(targetName));
                    }
                } else {
                    final Object objFind = fAllKnownTypesHashMap.get(attrType);
                    if (objFind == null) {
                        throw new IllegalArgumentException(bundle
                                .getXsdParserErr003(targetName, attrType));
                    }
                    // ComplexTypełB
                    if (isInComplexType) {
                        complexTypeStructure
                                .getListField()
                                .add(
                                        new ComplexTypeFieldStructure(
                                                (AbstractTypeStructure) objFind,
                                                attrName, attrMinOccurs,
                                                attrMaxOccurs));
                    } else {
                        if (IS_DEBUG) {
                            System.out
                                    .println("xsd[tns:"
                                            + targetName
                                            + "]ɂĕ^ł͂ȂӏelementJn܂B̐錾ƍl܂B̃Gg͖܂B");
                        }
                    }
                }
            }

            public void endElementXsdElement(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdElement(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdElement(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdAnnotation(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementXsdAnnotation(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdAnnotation(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdAnnotation(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdAppinfo(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementXsdAppinfo(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdAppinfo(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdAppinfo(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementJxbSchemaBindings(String uri,
                    String localName, String qName) throws SAXException {
            }

            public void endElementJxbSchemaBindings(String uri,
                    String localName, String qName) throws SAXException {
            }

            public void charactersJxbSchemaBindings(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceJxbSchemaBindings(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementJxbPackage(String uri, String localName,
                    String qName, String attrName) throws SAXException {
                // o͐pbP[WL܂B
                targetPackage = attrName;
                if (IS_DEBUG) {
                    System.out.println("pbP[Ww[" + targetPackage + "]");
                }
            }

            public void endElementJxbPackage(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersJxbPackage(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceJxbPackage(char[] ch, int start,
                    int length) throws SAXException {
            }
        });

        final TransformerFactory tf = TransformerFactory.newInstance();
        final Transformer transformer = tf.newTransformer();
        transformer.transform(new StreamSource(inStream), result);

        final Object objTarget = fAllKnownTypesHashMap.get("tns:" + targetName);
        if (objTarget == null) {
            throw new IllegalArgumentException(bundle
                    .getXsdParserErr004(targetName));
        }
        if (objTarget instanceof SimpleTypeStructure) {
            throw new IllegalArgumentException(bundle
                    .getXsdParserErr005(targetName));
        }
        if (objTarget instanceof ComplexTypeStructure) {
            return (ComplexTypeStructure) objTarget;
        } else {
            throw new IllegalArgumentException(bundle.getXsdParserErr006(
                    targetName, objTarget.getClass().getName()));
        }
    }
}