/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.wsdl.parser;

import java.io.File;
import java.util.HashMap;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeStructure;

/**
 * WSDLt@Cp[X܂B
 * 
 * ̃NX blancoWsdlWSDLt@Ĉ݂邱Ƃł܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlParser {
    /**
     * ݑĂWSDLt@C
     */
    private File fWsdlFile = null;

    /**
     * ̌ʂLIuWFNgB
     */
    private BlancoWsdlWebService fWsdl = null;

    /**
     * WSDLŌ^MAPŋL܂B
     */
    private HashMap fMapComplexTypeStructure = new HashMap();

    /**
     * ^ꂽWSDLt@C𑖍܂B̌ʂIuWFNgŖ߂܂B
     * 
     * @param arg
     *            WSDLt@C
     * @return ̌
     */
    public BlancoWsdlWebService parse(final File arg) {
        fWsdl = new BlancoWsdlWebService();
        fWsdlFile = arg;

        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fWsdlFile);
        final Document document = (Document) result.getNode();
        parseDocumentElement(document.getDocumentElement());
        return fWsdl;
    }

    /**
     * w肳ꂽO̕^̍\̂߂܂B
     * 
     * @param aName
     * @return
     */
    public ComplexTypeStructure getComplexTypeStructure(final String aName) {
        final Object find = fMapComplexTypeStructure.get(aName);
        if (find == null) {
            return null;
        }
        return (ComplexTypeStructure) find;
    }

    private void parseDocumentElement(final Element elementRoot) {
        fWsdl.setNamespace(elementRoot.getAttribute("xmlns:tns"));

        expandTypes(elementRoot);
        expandService(elementRoot);
        expandPortType(elementRoot);
    }

    /**
     * typesWJ܂BŏɎsKv܂B
     * 
     * @param elementRoot
     */
    private void expandTypes(final Element elementRoot) {
        final NodeList listTypes = elementRoot
                .getElementsByTagName("wsdl:types");
        for (int indexTypes = 0; indexTypes < listTypes.getLength(); indexTypes++) {
            final Node nodeLook = listTypes.item(indexTypes);
            if (nodeLook instanceof Element == false) {
                continue;
            }
            parseTypes((Element) nodeLook);
        }
    }

    private void parseTypes(final Element eleArg) {
        final NodeList nodeList = eleArg.getElementsByTagName("xsd:schema");
        for (int indexSchema = 0; indexSchema < nodeList.getLength(); indexSchema++) {
            final Node nodeLook = nodeList.item(indexSchema);
            if (nodeLook instanceof Element == false) {
                continue;
            }
            parseSchema((Element) nodeLook);
        }
    }

    private void parseSchema(final Element eleArg) {
        final NodeList nodeList = eleArg.getElementsByTagName("xsd:include");
        for (int indexSchema = 0; indexSchema < nodeList.getLength(); indexSchema++) {
            final Node nodeLook = nodeList.item(indexSchema);
            if (nodeLook instanceof Element == false) {
                continue;
            }
            parseInclude((Element) nodeLook);
        }
    }

    /**
     * XSDt@Cƃ^[QbgƂȂXSD̖̂Ƃv邱Ƃ肵Ă܂B
     * 
     * @param eleArg
     */
    private void parseInclude(final Element eleArg) {
        final String schemaLocation = eleArg.getAttribute("schemaLocation");
        if (schemaLocation.endsWith(".xsd") == false) {
            // ӁF.xsdŃt@C͏IƉ肵Ă܂B
            throw new IllegalArgumentException(
                    "WSDLt@C["
                            + fWsdlFile.getAbsolutePath()
                            + "] .xsdŏIȂXSDt@C̓ǂݍ݂̋Lڂ܂BXSDt@C.xsdŏÎw肷悤ɂĂB:"
                            + schemaLocation);
        }

        final File fileSchema = new File(fWsdlFile.getParent() + "/"
                + schemaLocation);
        if (fileSchema.exists() == false) {
            throw new IllegalArgumentException("WSDLt@C["
                    + fWsdlFile.getAbsolutePath() + "]Ŏw肳ĂXSDt@C["
                    + fileSchema.getAbsolutePath() + "]܂B");
        }

        try {
            final BlancoXsdParser parser = new BlancoXsdParser();
            final ComplexTypeStructure type = parser.process(fileSchema,
                    fileSchema.getName().substring(0,
                            fileSchema.getName().length() - ".xsd".length()));
            fMapComplexTypeStructure.put(type.getName(), type);
        } catch (Exception e) {
            throw new IllegalArgumentException("WSDLt@C["
                    + fWsdlFile.getAbsolutePath() + "]̏ɗO܂B"
                    + e.toString());
        }
    }

    private void expandPortType(final Element elementRoot) {
        final NodeList listService = elementRoot
                .getElementsByTagName("wsdl:portType");
        for (int indexService = 0; indexService < listService.getLength(); indexService++) {
            final Node nodeLook = listService.item(indexService);
            if (nodeLook instanceof Element == false) {
                continue;
            }
            parsePortType((Element) nodeLook);
        }
    }

    private void parsePortType(final Element eleArg) {
        final NodeList nodeList = eleArg.getElementsByTagName("wsdl:operation");
        for (int indexService = 0; indexService < nodeList.getLength(); indexService++) {
            final Node nodeLook = nodeList.item(indexService);
            if (nodeLook instanceof Element == false) {
                continue;
            }
            parseOperation((Element) nodeLook);
        }
    }

    private void parseOperation(final Element eleArg) {
        final String name = eleArg.getAttribute("name");
        if (name == null) {
            return;
        }

        final BlancoWsdlWebServiceOperation operation = new BlancoWsdlWebServiceOperation();
        operation.setName(name);

        final NodeList nodeList = eleArg.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); index++) {
            final Node nodeLook = nodeList.item(index);
            if (nodeLook instanceof Element == false) {
                continue;
            }
            final Element eleLook = (Element) nodeLook;
            final String messageName = eleLook.getNodeName();
            final String message = eleLook.getAttribute("message");

            // tns:ߑł܂B
            final String nameWithoutTns = message.substring("tns:".length());
            final ComplexTypeStructure complexTypeStructure = (ComplexTypeStructure) fMapComplexTypeStructure
                    .get(nameWithoutTns);

            if (messageName.equals("wsdl:input")) {
                if (complexTypeStructure == null) {
                    throw new IllegalArgumentException("WSDLt@C["
                            + fWsdlFile.getAbsolutePath() + "]̓["
                            + nameWithoutTns + "]ɑΉ镡^`܂");
                }
                operation.setInput(complexTypeStructure);
            } else if (messageName.equals("wsdl:output")) {
                if (complexTypeStructure == null) {
                    throw new IllegalArgumentException("WSDLt@C["
                            + fWsdlFile.getAbsolutePath() + "]̏o["
                            + nameWithoutTns + "]ɑΉ镡^`܂");
                }
                operation.setOutput(complexTypeStructure);
            } else {
                throw new IllegalArgumentException("z肵Ȃӏʉ߁BbZ[W["
                        + messageName + "]");
            }
        }
        fWsdl.getOperationList().add(operation);
    }

    private void expandService(final Element elementRoot) {
        final NodeList listService = elementRoot
                .getElementsByTagName("wsdl:service");

        for (int indexService = 0; indexService < listService.getLength(); indexService++) {
            final Node nodeLook = listService.item(indexService);
            if (nodeLook instanceof Element == false) {
                continue;
            }
            parseService((Element) nodeLook);
        }
    }

    private void parseService(final Element eleService) {
        final String name = eleService.getAttribute("name");
        if (name == null) {
            return;
        }

        fWsdl.setWebServiceId(name);

        // pbP[WǂݎB
        final Element elePackage = BlancoXmlUtil.getElement(eleService,
                "xsd:annotation/xsd:appinfo/jxb:schemaBindings/jxb:package");
        if (elePackage != null) {
            final String attrPackageName = elePackage.getAttribute("name");
            if (BlancoStringUtil.null2Blank(attrPackageName).length() > 0) {
                fWsdl.setPackage(attrPackageName);
                // System.out.println("TRACE: pbP[W[" + attrPackageName + "]");
            }
        }

        // pbP[Wm肵܂B
        if (BlancoStringUtil.null2Blank(fWsdl.getPackage()).length() == 0) {
            // WSDLannotationɃpbP[Ww肪Ȃꍇɂ́AOԂ疼Oό`ăpbP[WmB
            fWsdl.setPackage(BlancoNameUtil.uri2JavaPackage(fWsdl
                    .getNamespace()));
        } else {
            // WSDLannotationɃpbP[Ww肪ꍇɂ́Aꂪ̂܂܍̗p܂B
        }
    }
}
