/*
 * blanco Framework Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.soap;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.commons.util.BlancoFileUtil;
import blanco.wsdl.parser.BlancoWsdlParser;
import blanco.wsdl.valueobject.BlancoWsdlWebService;

/**
 * .NET Framework SDK  wsdl.exeR}hbsONXB
 * 
 * wsdl.exeR}h𗘗p WSDLWebT[rXvLV܂B<br>
 * .NET Framework 1.1ɑΉĂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoSoapDotNetWsdlExe {
    /**
     * WSDLp[Xēꂽ
     */
    private BlancoWsdlWebService fWsdl = null;

    /**
     * .NET Framework SDK̃fBNg (wsdl.exei[ĂfBNg̈)
     */
    private String fDotNetSdkDir = "C:\\Program Files\\Microsoft.NET\\SDK\\v1.1";

    /**
     * T[o𐶐郂[hł邩ǂB
     */
    private boolean fIsServer = true;

    public void setDotNetSdkDir(final String arg) {
        fDotNetSdkDir = arg;
    }

    public String getDotNetSdkDir() {
        return fDotNetSdkDir;
    }

    public void setServer(final boolean arg) {
        fIsServer = arg;
    }

    public boolean getServer() {
        return fIsServer;
    }

    /**
     * WSDLt@C .NET Framework SDK  wsdl.exeR}h𗘗p C#.NETt@Cɕϊ܂B
     * 
     * @param metaFile
     *            t@C *.wsdlłKv܂B
     * @param targetDirectory
     * @throws TransformerException
     * @throws IOException
     */
    public void process(final File metaFile, final File targetDirectory)
            throws TransformerException, IOException {
        fWsdl = new BlancoWsdlParser().parse(metaFile);

        final File workDir = metaFile.getParentFile();
        if (workDir.exists() == false) {
            throw new IllegalArgumentException("^t@Ci[ĂfBNg["
                    + workDir.getAbsolutePath()
                    + "]݂̂̂܂Bz肵ȂOłBf܂B");
        }
        if (new File(getDotNetSdkDir()).exists() == false) {
            throw new IllegalArgumentException(".NET Framework SDK̃fBNg["
                    + getDotNetSdkDir() + "]܂Bf܂B");
        }
        if (new File(getDotNetSdkDir() + "\\Bin").exists() == false) {
            throw new IllegalArgumentException(
                    ".NET Framework SDK̎sW[fBNg[" + getDotNetSdkDir()
                            + "\\Bin" + "]܂Bf܂B");
        }
        if (new File(getDotNetSdkDir() + "\\Bin\\wsdl.exe").exists() == false) {
            throw new IllegalArgumentException(
                    ".NET Framework SDKwsdl.exeR}h[" + getDotNetSdkDir()
                            + "\\Bin\\wsdl.exe]܂Bf܂B");
        }

        final File fileTargetSubDirectory = new File(targetDirectory
                .getAbsolutePath()
                + "\\main\\" + fWsdl.getPackage().replace('.', '\\'));
        if (fileTargetSubDirectory.exists() == false) {
            System.out.println("fBNg쐬["
                    + fileTargetSubDirectory.getAbsolutePath() + "]");
            fileTargetSubDirectory.mkdirs();
        }

        final String targetSourceFileName = fWsdl.getWebServiceId() + ".cs";
        final String csNameSpace = fWsdl.getPackage();

        fWsdl = new BlancoWsdlParser().parse(metaFile);
        try {
            processProc(metaFile, workDir, targetSourceFileName, csNameSpace);

            processCopy(targetSourceFileName, workDir, targetDirectory,
                    csNameSpace);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /**
     * vZXs܂B
     * 
     * @param workDir
     * @param targetSourceFileName
     * @param csNameSpace
     * @throws IOException
     * @throws InterruptedException
     */
    private void processProc(final File metaFile, final File workDir,
            final String targetSourceFileName, final String csNameSpace)
            throws IOException, InterruptedException {
        Process proc = null;
        if (getServer()) {
            proc = Runtime.getRuntime().exec(
                    new String[] { "CMD.EXE", "/C",
                            getDotNetSdkDir() + "\\Bin\\wsdl.exe", "/server",
                            "/namespace:" + csNameSpace, metaFile.getName(),
                            "/out:" + targetSourceFileName }, null, workDir);
        } else {
            proc = Runtime.getRuntime().exec(
                    new String[] { "CMD.EXE", "/C",
                            getDotNetSdkDir() + "\\Bin\\wsdl.exe",
                            "/namespace:" + csNameSpace, metaFile.getName(),
                            "/out:" + targetSourceFileName }, null, workDir);
        }
        try {
            final ByteArrayOutputStream stdOutStream = new ByteArrayOutputStream();

            final BlancoCopyStreamThread threadOut = new BlancoCopyStreamThread(
                    proc.getInputStream(), stdOutStream);
            threadOut.start();
            final BlancoCopyStreamThread threadErr = new BlancoCopyStreamThread(
                    proc.getErrorStream(), stdOutStream);
            threadErr.start();

            final int retCode = proc.waitFor();
            threadOut.stopCopy();
            threadErr.stopCopy();
            stdOutStream.flush();
            if (retCode == 0) {
                // ϊ͐I܂B
            } else {
                throw new IllegalArgumentException("wsdl.exesُI܂BIR[h("
                        + retCode + ")B"
                        + new String(stdOutStream.toByteArray()));
            }
        } finally {
            proc.destroy();
        }
    }

    /**
     * s̃t@CRs[ьt@C폜s܂B
     * 
     * @param targetSourceFileName
     * @param workDir
     * @param targetDirectory
     * @param csNameSpace
     * @throws IOException
     */
    private void processCopy(final String targetSourceFileName,
            final File workDir, final File targetDirectory,
            final String csNameSpace) throws IOException {
        final File fileSource = new File(workDir.getAbsoluteFile() + "/"
                + targetSourceFileName);
        final File fileTarget = new File(targetDirectory.getAbsolutePath()
                + "/main/" + csNameSpace.replace('.', '/') + "/"
                + targetSourceFileName);
        BlancoFileUtil.copy(fileSource, fileTarget);
        // System.out.println("t@C[" + fileTarget + "]쐬܂B");

        // ŌɃRs[t@C͍폜܂B
        fileSource.delete();
    }
}
