/*
 * blanco Framework Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.soap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.xml.transform.TransformerException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGeneratorDotNet;
import blanco.soap.dotnet.wsdl2cs.BlancoSoapDotnetWsdl2CsExpandAbstractTelegramProcessor;
import blanco.soap.dotnet.wsdl2cs.BlancoSoapDotnetWsdl2CsExpandTelegramProcessorProxy;
import blanco.soap.dotnet.wsdl2cs.client.BlancoSoapDotnetWsdl2CsExpandTelegramProcessorClient;
import blanco.wsdl.parser.BlancoWsdlParser;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

public class BlancoSoapWsdl2CsClass {
    private BlancoWsdlWebService fWsdl = null;

    /**
     * 
     * @param metaFile
     *            ΏۂWSDL(^t@C)B
     * @param targetDirectory
     *            o͐fBNgB
     * @param isServer
     *            T[oo͂邩ǂBtrueȂT[oBfalseȂNCAgB
     * @throws TransformerException
     *             XMLϊOꍇB
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File metaFile, final File targetDirectory,
            final boolean isServer) throws TransformerException, IOException {
        fWsdl = new BlancoWsdlParser().parse(metaFile);

        if (isServer) {
            final ArrayList listOperation = fWsdl.getOperationList();
            for (int indexOperation = 0; indexOperation < listOperation.size(); indexOperation++) {
                final BlancoWsdlWebServiceOperation operation = (BlancoWsdlWebServiceOperation) listOperation
                        .get(indexOperation);
                // System.out.println(operation.getName());
                expandOperation(operation, targetDirectory);
            }

            // Microsoft .NET Framework 1.1 WSDL̖̂̂܂܃NXƂĂB
            generateSource(
                    new BlancoSoapDotnetWsdl2CsExpandTelegramProcessorProxy(
                            new IgType(fWsdl.getPackage(), fWsdl
                                    .getWebServiceId()
                                    + "Proxy"), fWsdl), targetDirectory);
        } else {
            // NCAg𐶐B
            generateSource(
                    new BlancoSoapDotnetWsdl2CsExpandTelegramProcessorClient(
                            new IgType(fWsdl.getPackage(), fWsdl
                                    .getWebServiceId()
                                    + "Proxy"), fWsdl), targetDirectory);
        }
    }

    private void expandOperation(final BlancoWsdlWebServiceOperation operation,
            final File targetDirectory) throws IOException {
        generateSource(
                new BlancoSoapDotnetWsdl2CsExpandAbstractTelegramProcessor(
                        new IgType(fWsdl.getPackage(), "Abstract"
                                + BlancoNameAdjuster.toClassName(operation
                                        .getName()) + "TelegramProcessor"),
                        fWsdl, operation), targetDirectory);
    }

    private static void generateSource(ClassExpander classExpander,
            File directoryTarget) throws IOException {
        final GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(directoryTarget.getAbsolutePath());
        ImplementGeneratorDotNet implementGenerator = new ImplementGeneratorDotNet(
                setting);
        // 쐬NXo^܂B
        implementGenerator.addMain(classExpander);
        // ۂɃ\[XR[hs܂B
        implementGenerator.generate();
        // System.out.println("\[XR[h܂B");
    }
}
