/*
 * blanco Framework Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.soap.dotnet.wsdl2cs;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.IgStatement;
import blanco.ig.expander.method.MethodExpander;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

public class BlancoSoapDotnetWsdl2CsExpandAbstractTelegramProcessor extends
        ClassExpander {
    private BlancoWsdlWebService fWsdl = null;

    private BlancoWsdlWebServiceOperation fOperation = null;

    protected boolean isAbstract() {
        return true;
    }

    public BlancoSoapDotnetWsdl2CsExpandAbstractTelegramProcessor(
            final IgType type, final BlancoWsdlWebService wsdl,
            final BlancoWsdlWebServiceOperation operation) {
        super(type);
        this.fWsdl = wsdl;
        this.fOperation = operation;
    }

    protected void expandClassStruct() {
        addFileComment("̃NX blancoɂ莩Ă܂B");

        getJavaDoc().addLine(
                "WebT[rX[" + fWsdl.getWebServiceId() + "]Ad["
                        + fOperation.getName() + "]̒ۃNXB");
        getJavaDoc().addLine("̃NXpāAۂ̓dĂB");

        addImport(new IgType("System.int"));
        // addImport(new Type(input.getTypeOfJava()));
        // addImport(new Type(output.getTypeOfJava()));

        final FieldExpander fieldConnection = new FieldExpander(new IgType(
                "System.Data.SqlClient.SqlConnection"), "fConnection");
        fieldConnection.getJavaDoc().addLine("f[^x[XڑIuWFNgL܂B");
        addField(fieldConnection);

        final FieldExpander fieldTransaction = new FieldExpander(new IgType(
                "System.Data.SqlClient.SqlTransaction"), "fTransaction");
        fieldTransaction.getJavaDoc().addLine("gUNVIuWFNgL܂B");
        addField(fieldTransaction);

        final FieldExpander fieldRollback = new FieldExpander(
                new IgType("bool"), "fRollback");
        fieldRollback.setDefaultStatement(new IgStatement("false"));
        fieldRollback.getJavaDoc().addLine(
                "dIɃ[obN𔭍s邩ǂBftHgfalseB");
        addField(fieldRollback);

        addMethod(new MethodExpander("Execute") {
            protected boolean isAbstract() {
                return true;
            }

            public void setupSignature() {
                getJavaDoc().addLine(
                        "WebT[rX[" + fWsdl.getWebServiceId() + "]Ad["
                                + fOperation.getName()
                                + "]̎ۂ̏p惁\bhŎ܂B");
                getJavaDoc().addLine("̃\bhA傤ǃf[^x[XgUNVEƂȂ܂B");
                getJavaDoc().addLine(
                        "̃\bhł̓gUNṼR~bg⃍[obN͂ȂȂłB");
                getJavaDoc().addLine(
                        "\bhIΊÕvLVNXŃf[^x[XgUNṼR~bgȂ܂B");
                getJavaDoc()
                        .addLine(
                                "\bhOɂ蒆fΊÕvLVNXŃf[^x[XgUNṼ[obNȂ܂B");
                getJavaDoc().addParameter("input",
                        "d̗vd[" + fOperation.getInput().getName() + "]B");
                addArgument(new IgValue(new IgType(fOperation.getInput()
                        .getPackageOfJava(), fOperation.getInput().getName()),
                        "input"));
                getJavaDoc().addReturn(
                        "d̉d[" + fOperation.getOutput().getName() + "]B");
                setReturnType(new IgType(fOperation.getOutput()
                        .getPackageOfJava(), fOperation.getOutput().getName()));
            }

            public void implement() {
            }
        });

        addMethod(new MethodExpander("SetConnection") {
            public void setupSignature() {
                getJavaDoc().addLine("RlNVIuWFNgݒ肵܂B");
                getJavaDoc().addParameter("arg", "f[^x[XڑIuWFNg");
                addArgument(new IgValue(new IgType(
                        "System.Data.SqlClient.SqlConnection"), "arg"));
            }

            public void implement() {
                getData().addLine("fConnection = arg;");
            }
        });

        addMethod(new MethodExpander("GetConnection") {
            public void setupSignature() {
                getJavaDoc().addLine("RlNVIuWFNg擾܂B");
                getJavaDoc().addReturn("f[^x[XڑIuWFNg");
                setReturnType(new IgType("System.Data.SqlClient.SqlConnection"));
            }

            public void implement() {
                getData().addLine("return fConnection;");
            }
        });

        addMethod(new MethodExpander("SetTransaction") {
            public void setupSignature() {
                getJavaDoc().addLine("gUNVIuWFNgݒ肵܂B");
                getJavaDoc().addParameter("arg", "gUNVIuWFNg");
                addArgument(new IgValue(new IgType(
                        "System.Data.SqlClient.SqlTransaction"), "arg"));
            }

            public void implement() {
                getData().addLine("fTransaction = arg;");
            }
        });

        addMethod(new MethodExpander("GetTransaction") {
            public void setupSignature() {
                getJavaDoc().addLine("gUNVIuWFNg擾܂B");
                getJavaDoc().addReturn("gUNVIuWFNg");
                setReturnType(new IgType("System.Data.SqlClient.SqlTransaction"));
            }

            public void implement() {
                getData().addLine("return fTransaction;");
            }
        });

        addMethod(new MethodExpander("SetRollback") {
            public void setupSignature() {
                getJavaDoc().addLine("dIɃ[obNȂǂݒ肵܂B");
                getJavaDoc().addParameter("arg", "dIɃ[obNȂǂB");
                addArgument(new IgValue(new IgType("bool"), "arg"));
            }

            public void implement() {
                getData().addLine("fRollback = arg;");
            }
        });

        addMethod(new MethodExpander("GetRollback") {
            public void setupSignature() {
                getJavaDoc().addLine("dIɃ[obNȂǂ擾܂B");
                getJavaDoc().addReturn("dIɃ[obNȂǂB");
                setReturnType(new IgType("bool"));
            }

            public void implement() {
                getData().addLine("return fRollback;");
            }
        });
    }
}
