/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.common.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * blancoDbpQueryp[XE[eBeBNX
 * 
 * SQL̉߂ѕϊȂǂړIƂ܂B
 * 
 * @author Tosiki Iga
 */
public class BlancoDbQueryParserUtil {
    /**
     * SQL̓p[^ƂĔ肷邽߂̐K\B
     */
    private static final String SZ_PARAMETER_FOR_SQL_INPUT_PARAMETER = "#[a-zA-Z0-9.\\-_\\P{InBasicLatin}]*\\b|#.*$";

    /**
     * SQL̓p[^̃}bv <br>
     * TODO }bv𗘗pĂ܂AꂾƏmۂ܂B
     */
    private final Map fMapForSqlInputParameters = new Hashtable();

    /**
     * IWiSQL
     */
    private String fOriginalSqlQueryString = "";

    public BlancoDbQueryParserUtil(final String sqlQueryString) {
        // p[^L܂B
        fOriginalSqlQueryString = sqlQueryString;

        // K\CX^X𐶐܂B
        // TODO K\ɂ鏈ɂĕsK؂ȏ󋵂\܂B
        final Matcher matcher = Pattern.compile(
                SZ_PARAMETER_FOR_SQL_INPUT_PARAMETER).matcher(
                fOriginalSqlQueryString);

        for (int index = 1; matcher.find(); index++) {
            String name = matcher.group();
            // 擪́܂B
            name = name.substring(1, name.length());
            if (fMapForSqlInputParameters.containsKey(name) == false) {
                fMapForSqlInputParameters.put(name, new ArrayList());
            }
            ((ArrayList) fMapForSqlInputParameters.get(name)).add(new Integer(
                    index));
        }

        for (Iterator ite = fMapForSqlInputParameters.keySet().iterator(); ite
                .hasNext();) {
            final String key = (String) ite.next();
            final List list = (List) fMapForSqlInputParameters.get(key);
            fMapForSqlInputParameters.put(key, convertListToArray(list));
        }
    }

    /**
     * ͂ꂽSQL̓p[^intzɕϊ܂B
     * 
     * @param sqlInputParameterFoundList
     * @return
     */
    private int[] convertListToArray(final List sqlInputParameterFoundList) {
        final int[] convertedIntArray = new int[sqlInputParameterFoundList
                .size()];
        final Iterator ite = sqlInputParameterFoundList.iterator();
        for (int index = 0; ite.hasNext(); index++) {
            convertedIntArray[index] = ((Integer) ite.next()).intValue();
        }
        return convertedIntArray;
    }

    /**
     * FL[ɁAintQbg܂B
     * 
     * @param key
     * @return
     */
    public int[] getSqlParameters(final String key) {
        // }bvIterator쐬Ă_ɒӁB
        return (int[]) fMapForSqlInputParameters.get(key);
    }

    /**
     * JDBCɎۂɔsۂɗpi`SQL
     * 
     * SQL烁^擾ۂɗp܂B܂ADotNetłȂ
     * JavaňȊO̔ł̃\[XR[h̍ۂɁÃ\bhp܂B
     * 
     * @return
     */
    public String getNaturalSqlStringForJava() {
        return fOriginalSqlQueryString.replaceAll(
                SZ_PARAMETER_FOR_SQL_INPUT_PARAMETER, "?");
    }
}