/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.stringgroup.resourcebundle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoStringGroup]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoStringGroupResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoStringGroupResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoStringGroup]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoStringGroupResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoStringGroup");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoStringGroupResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoStringGroup]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoStringGroupResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoStringGroup", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoStringGroupResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoStringGroup]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoStringGroupResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoStringGroup", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * bundle[BlancoStringGroup], key[METAFILE_DISPLAYNAME]
     *
     * [O[v`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "O[v`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[METAFILE_DISPLAYNAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoStringGroup], key[META2XML.ELEMENT_COMMON]
     *
     * [blancostringgroup-common] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_COMMON]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementCommon() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancostringgroup-common";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_COMMON");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[META2XML.ELEMENT_COMMON]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoStringGroup], key[META2XML.ELEMENT_LIST]
     *
     * [blancostringgroup-list] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_LIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementList() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancostringgroup-list";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_LIST");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[META2XML.ELEMENT_LIST]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoStringGroup], key[XML2SOURCE_FILE.ERR001]
     *
     * [O[v`ID[{0}]̃pbP[Ww肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "O[v`ID[{0}]̃pbP[Ww肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[XML2SOURCE_FILE.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoStringGroup], key[XML2SOURCE_FILE.ERR002]
     *
     * [T|[gȂo̓vO~Oꏈn[{0}]w肳܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileErr002(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "T|[gȂo̓vO~Oꏈn[{0}]w肳܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.ERR002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[XML2SOURCE_FILE.ERR002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoStringGroup], key[XML2SOURCE_FILE.ERR003]
     *
     * [O[v`ID[{0}]ɂāA[{1}]2ȏ゠܂Bl2ȏwł܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileErr003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "O[v`ID[{0}]ɂāA[{1}]2ȏ゠܂Bl2ȏwł܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.ERR003");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[XML2SOURCE_FILE.ERR003]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoStringGroup], key[XML2SOURCE_FILE.FIELD_NO]
     *
     * [No.{0}] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.FIELD_NO]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileFieldNo(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "No.{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.FIELD_NO");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[XML2SOURCE_FILE.FIELD_NO]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoStringGroup], key[XML2SOURCE_FILE.DESCRIPTION]
     *
     * [:{0}] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.DESCRIPTION]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileDescription(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = ":{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.DESCRIPTION");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[XML2SOURCE_FILE.DESCRIPTION]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoStringGroup], key[ANTTASK.ERR001]
     *
     * [^fBNg[{0}]݂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[ANTTASK.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getAnttaskErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^fBNg[{0}]݂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("ANTTASK.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoStringGroup]AL[[ANTTASK.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
