/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.stringgroup.BlancoDbLoggingModeStringGroup;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilJava;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi
 */
public class ExecuteUpdateMethod extends BlancoDbAbstractMethod {
    public ExecuteUpdateMethod(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                "executeUpdate", "SQLs܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.setReturn(fCgFactory.createReturn("int", "ꂽs"));

        /*
         * VOLłꍇɂ protectedƂ܂B
         */
        if (fSqlInfo.getSingle()) {
            cgMethod.setAccess("protected");
        } else {
            // publiĉ܂܂łB
        }

        BlancoDbCgUtilJava.addExceptionToMethodIntegrityConstraintException(
                fCgFactory, cgMethod, fDbSetting);
        BlancoDbCgUtilJava.addExceptionToMethodDeadlockTimeoutException(
                fCgFactory, cgMethod, fDbSetting);
        BlancoDbCgUtilJava.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        if (fSqlInfo.getSingle()) {
            cgMethod.getLangDoc().getDescriptionList().add(
                    "VOLȂ̂ŃXR[vprotectedƂ܂B<br>");
            cgMethod.getLangDoc().getDescriptionList().add(
                    "̃\bh̑ executeSingleUpdate\bh𗘗pĂB<br>");
        }

        final List listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            switch (fDbSetting.getLoggingMode()) {
            case BlancoDbLoggingModeStringGroup.DEBUG:
                BlancoDbCgUtilJava.addBeginLogToMethod(cgMethod);
                break;
            case BlancoDbLoggingModeStringGroup.PERFORMANCE:
            case BlancoDbLoggingModeStringGroup.SQLID:
                // ܂B
                break;
            }
        }

        // statementmۂł΂AIprepareStatementĂяo܂B
        listLine.add("if (fStatement == null) {");
        listLine
                .add("// PreparedStatement擾̏ԂȂ̂ŁAPreparedStatement.executeUpdate()sɐ旧prepareStatement()\bhĂяoĎ擾܂B");
        listLine.add("prepareStatement();");
        listLine.add("}");

        listLine.add("");

        if (fDbSetting.getLogging()) {
            switch (fDbSetting.getLoggingMode()) {
            case BlancoDbLoggingModeStringGroup.DEBUG:
                // ܂B
                break;
            case BlancoDbLoggingModeStringGroup.PERFORMANCE:
            case BlancoDbLoggingModeStringGroup.SQLID:
                listLine.add("final Runtime runtime = Runtime.getRuntime();");
                listLine
                        .add("final long usedMemoryStart = getUsedMemory(runtime);");
                listLine
                        .add("final long startTime = System.currentTimeMillis();");
                listLine.add("fLog.info(\"\vF" + fSqlInfo.getName()
                        + "Jn\");");
                break;
            }
            listLine.add("");
        }

        // O܂߂ēWJ܂B
        listLine.add("try {");
        listLine.add("return fStatement.executeUpdate();");
        listLine.add("} catch (SQLException ex) {");
        listLine.add("throw BlancoDbUtil.convertToBlancoException(ex);");

        if (fDbSetting.getLogging()) {
            switch (fDbSetting.getLoggingMode()) {
            case BlancoDbLoggingModeStringGroup.DEBUG:
                // ܂B
                break;
            case BlancoDbLoggingModeStringGroup.PERFORMANCE:
            case BlancoDbLoggingModeStringGroup.SQLID:
                listLine.add("} finally {");
                listLine
                        .add("final long endTime = System.currentTimeMillis();");
                listLine
                        .add("final long usedMemoryEnd = getUsedMemory(runtime);");
                listLine
                        .add("fLog.info(\"\vF"
                                + fSqlInfo.getName()
                                + "I vԁF\" + getTimeString(endTime - startTime) + \" IgpF\" + getMemorySizeString(usedMemoryEnd) + \" gpF\" + getMemorySizeString(usedMemoryEnd - usedMemoryStart));");
                break;
            }
        }

        listLine.add("}");
    }
}