/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.common.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;

import blanco.db.common.stringgroup.BlancoDbDriverNameStringGroup;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataKeyStructure;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataTableStructure;

public class BlancoDbUtil {
    /**
     * vC}L[ł邩ǂ`FbN郁\bhB
     * 
     * @param table
     * @param columnStructure
     * @return
     */
    public static boolean isPrimaryKey(
            final BlancoDbMetaDataTableStructure table,
            final BlancoDbMetaDataColumnStructure columnStructure) {
        for (int index = 0; index < table.getPrimaryKeys().size(); index++) {
            final BlancoDbMetaDataKeyStructure columnLook = (BlancoDbMetaDataKeyStructure) table
                    .getPrimaryKeys().get(index);
            if (columnLook.getPkcolumnName().equals(columnStructure.getName())) {
                // vC}L[łB
                return true;
            }
        }
        return false;
    }

    /**
     * ^CpbP[W̃[gtH_擾܂B
     * 
     * w肪Ȃꍇɂ͊fBNgp܂B
     * 
     * @param dbSetting
     * @return
     */
    public static String getRuntimePackage(final BlancoDbSetting dbSetting) {
        String runtimePackage = dbSetting.getBasePackage();
        if (dbSetting.getRuntimePackage() != null) {
            runtimePackage = dbSetting.getRuntimePackage();
        }
        return runtimePackage;
    }

    /**
     * f[^x[Xڑ̊m݂܂B
     * 
     * @param connDef
     * @throws SQLException
     * @throws ClassNotFoundException
     */
    public static Connection connect(final BlancoDbSetting dbSetting)
            throws SQLException {
        System.out.println("f[^x[XڑI[v܂.");
        try {
            System.out.println("  Driver:" + dbSetting.getJdbcdriver());
            Class.forName(dbSetting.getJdbcdriver());
        } catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("JDBChCõ[hɎs܂: "
                    + ex.toString());
        }

        try {
            System.out.println("  URL:" + dbSetting.getJdbcurl());
            System.out.println("  User:" + dbSetting.getJdbcuser());
            final Connection conn = DriverManager.getConnection(dbSetting
                    .getJdbcurl(), dbSetting.getJdbcuser(), dbSetting
                    .getJdbcpassword());

            // R~bgOFFɐݒ肵܂B
            conn.setAutoCommit(false);
            return conn;
        } catch (SQLException ex) {
            System.out.println("JDBCڑ̊mɎs܂: " + ex.toString());
            throw ex;
        }
    }

    public static void close(final Connection conn) {
        if (conn != null) {
            try {
                System.out.println("f[^x[XڑN[Y܂. (rollbackclose܂)");
                try {
                    conn.rollback();
                } finally {
                    conn.close();
                }
            } catch (SQLException e) {
                System.out.println("JDBCڑ̊JɎs܂: " + e.toString());
                e.printStackTrace();
            }
        }
    }

    /**
     * f[^x[X̃o[WȂǂ擾܂B
     */
    public static void getDatabaseVersionInfo(final Connection conn,
            final BlancoDbSetting dbSetting) {
        System.out.println("JDBChCo̊b擾܂B");
        try {
            final DatabaseMetaData databaseMetaData = conn.getMetaData();

            String driverName = databaseMetaData.getDriverName();
            final String _driverVersion = databaseMetaData.getDriverVersion();
            System.out.println("  DriverName:" + driverName);
            System.out.println("  DriverVersion:" + _driverVersion);

            try {
                System.out.println("  DatabaseMajorVersion:"
                        + databaseMetaData.getDatabaseMajorVersion());
                System.out.println("  DatabaseMinorVersion:"
                        + databaseMetaData.getDatabaseMinorVersion());
            } catch (java.lang.AbstractMethodError er) {
                // SQL Server 2000 JDBC Driver ̃\bhT|[g܂B
                // System.out.println(er.toString());
            } catch (SQLException ex) {
            }
            try {
                System.out.println("  JDBCMajorVersion:"
                        + databaseMetaData.getJDBCMajorVersion());
                System.out.println("  JDBCMinorVersion:"
                        + databaseMetaData.getJDBCMinorVersion());
            } catch (java.lang.AbstractMethodError er) {
                // SQL Server 2000 JDBC Driver ̃\bhT|[g܂B
                // System.out.println(er.toString());
            } catch (SQLException ex) {
                // Oracle 9i JDBC Driver ̃\bhT|[g܂B
            }

            dbSetting.setDriverName(new BlancoDbDriverNameStringGroup()
                    .convertToInt(driverName));
            if (BlancoDbDriverNameStringGroup.NOT_DEFINED == dbSetting
                    .getDriverName()) {
                System.out.println("mJDBChCoł: " + driverName);
            }

        } catch (SQLException e1) {
            e1.printStackTrace();
            return;
        }
    }
}
