/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.php;

import java.util.ArrayList;
import java.util.List;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.valueobject.BlancoCgException;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgLine;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgMethod\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgMethodPhpSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.PHP;

    /**
     * Ń\bhWJ܂B
     * 
     * @param strClassName
     *            NXB
     * @param cgMethod
     *            ΏۂƂȂ郁\bhB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            o͐sXgB
     * @param argIsInterface
     *            C^tF[XǂBNX̏ꍇɂfalseBC^tF[X̏ꍇɂtrueB
     */
    public void transformMethod(final String strClassName,
            final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines,
            final boolean argIsInterface) {
        if (BlancoStringUtil.null2Blank(cgMethod.getName()).length() == 0) {
            throw new IllegalArgumentException("\bh̖OɓK؂Ȓlݒ肳Ă܂B");
        }
        if (cgMethod.getReturn() == null) {
            // ͂肦܂Bvoid̏ꍇɂnullw肳̂łB
        }

        // st^B
        argSourceLines.add("");

        prepareExpand(cgMethod, argSourceFile);

        // 񂪈ꎮ̂ŁA\[XR[h̎ۂ̓WJs܂B

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocPhpSourceExpander().transformLangDoc(cgMethod
                .getLangDoc(), argSourceLines);

        // Ame[VWJB
        expandAnnotationList(cgMethod, argSourceLines);

        // \bh̖{̕WJB
        expandMethodBody(strClassName, cgMethod, argSourceFile, argSourceLines,
                argIsInterface);
    }

    /**
     * \[XR[hWJɐ旧AKvȏ̎Ws܂B
     * 
     * @param cgMethod
     *            \bhIuWFNgB
     * @param argSourceFile
     *            \[Xt@CB
     */
    private void prepareExpand(final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile) {
        // ŏɃ\bhLangDocɓWJB
        if (cgMethod.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgMethod.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgMethod.getLangDoc().getParameterList() == null) {
            cgMethod.getLangDoc().setParameterList(new ArrayList());
        }
        if (cgMethod.getLangDoc().getThrowList() == null) {
            cgMethod.getLangDoc().setThrowList(new ArrayList());
        }
        if (cgMethod.getLangDoc().getTitle() == null) {
            cgMethod.getLangDoc().setTitle(cgMethod.getDescription());
        }

        for (int indexParameter = 0; indexParameter < cgMethod
                .getParameterList().size(); indexParameter++) {
            final Object objParameter = cgMethod.getParameterList().get(
                    indexParameter);
            if (objParameter instanceof BlancoCgParameter == false) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]̃p[^ɕsȌ^[" + objParameter.getClass().getName()
                        + "]^܂B");
            }
            final BlancoCgParameter cgParameter = (BlancoCgParameter) objParameter;

            // importɌ^ǉB
            argSourceFile.getImportList().add(cgParameter.getType().getName());

            // hLgɃp[^ǉB
            cgMethod.getLangDoc().getParameterList().add(cgParameter);
        }

        if (cgMethod.getReturn() != null) {
            // importɌ^ǉB
            argSourceFile.getImportList().add(
                    cgMethod.getReturn().getType().getName());

            // hLgreturnǉB
            cgMethod.getLangDoc().setReturn(cgMethod.getReturn());
        }

        // OɂLangDoc\̂ɓWJ
        for (int index = 0; index < cgMethod.getThrowList().size(); index++) {
            final Object objException = cgMethod.getThrowList().get(index);
            if (objException instanceof BlancoCgException == false) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]throwsBlancoCgExceptionȊǑ^["
                        + objException.getClass().getName() + "]^܂B");
            }
            final BlancoCgException cgException = (BlancoCgException) objException;

            // importɌ^ǉB
            argSourceFile.getImportList().add(cgException.getType().getName());

            // hLgɗOǉB
            cgMethod.getLangDoc().getThrowList().add(cgException);
        }
    }

    /**
     * \bh̖{̕WJ܂B
     * 
     * @param strClassName
     *            NXB
     * @param cgMethod
     *            \bhIuWFNgB
     * @param argSourceLines
     *            \[XR[hB
     * @param argIsInterface
     *            C^tF[XƂēWJ邩ǂB
     */
    private void expandMethodBody(final String strClassName,
            final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines,
            final boolean argIsInterface) {
        final StringBuffer buf = new StringBuffer();

        if (BlancoStringUtil.null2Blank(cgMethod.getAccess()).length() > 0) {
            if (argIsInterface && cgMethod.getAccess().equals("public")) {
                // C^tF[Xpublic̏ꍇɂ͏o͂}܂B
                // Checkstyle΍ƂȂ܂B
            } else {
                buf.append(cgMethod.getAccess() + " ");
            }
        }

        if (cgMethod.getAbstract() && argIsInterface == false) {
            // C^tF[X̏ꍇɂ abstract͕t^܂B
            buf.append("abstract ");
        }
        if (cgMethod.getStatic()) {
            buf.append("static ");
        }
        if (cgMethod.getFinal() && argIsInterface == false) {
            // C^tF[X̏ꍇɂ final͕t^܂B
            buf.append("final ");
        }

        if (cgMethod.getConstructor()) {
            // RXgN^̏ꍇɂ́A߂l݂͑܂B
            // ̂߁Ał͉o͂܂B
        } else {
            if (cgMethod.getReturn() != null
                    && cgMethod.getReturn().getType() != null) {
                buf.append("/*."
                        + BlancoCgTypePhpSourceExpander
                                .toPhpLintType(BlancoCgTypePhpSourceExpander
                                        .toTypeString(cgMethod.getReturn()
                                                .getType())) + ".*/ ");
            } else {
                buf.append("/*.void.*/ ");
            }
        }

        buf.append("function ");

        if (cgMethod.getConstructor()) {
            // RXgN^̏ꍇA\bh͗p܂B
            buf.append("__construct(");
        } else {
            buf.append(cgMethod.getName() + "(");
        }

        for (int index = 0; index < cgMethod.getParameterList().size(); index++) {
            final BlancoCgParameter cgParameter = (BlancoCgParameter) cgMethod
                    .getParameterList().get(index);
            if (cgParameter.getType() == null) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]̃p[^[" + cgParameter.getName()
                        + "]Ɍ^null^܂B");
            }

            if (index != 0) {
                buf.append(", ");
            }

            if (cgParameter.getFinal()) {
                // PHP5ł̓p[^final͂܂B
                // buf.append("final ");
            }
            buf.append("/*.");
            buf.append(BlancoCgTypePhpSourceExpander
                    .toPhpLintType(BlancoCgTypePhpSourceExpander
                            .toTypeString(cgParameter.getType())));
            buf.append(".*/ ");
            buf.append("$" + cgParameter.getName());
        }
        buf.append(")");

        // OX[WJB
        expandThrowList(cgMethod, buf);

        if (cgMethod.getAbstract() || argIsInterface) {
            // ۃ\bh܂̓C^tF[X̏ꍇɂ́A\bh̖{̂WJ܂B
            buf.append(BlancoCgLineUtil.getTerminator(TARGET_LANG));
            argSourceLines.add(buf.toString());
        } else {
            // \bhubN̊JnB
            buf.append(" {");

            // łAsmB
            argSourceLines.add(buf.toString());

            // eNX\bhs@\̓WJB
            if (BlancoStringUtil.null2Blank(cgMethod.getSuperclassInvocation())
                    .length() > 0) {
                // super() Ȃǂ܂܂܂B
                argSourceLines.add(cgMethod.getSuperclassInvocation()
                        + BlancoCgLineUtil.getTerminator(TARGET_LANG));
            }

            argSourceLines.add("/* p[^̐A^`FbNs܂B */");
            argSourceLines.add(BlancoCgLineUtil
                    .getIfBegin(TARGET_LANG, "func_num_args() !== "
                            + cgMethod.getParameterList().size()));

            // standardimport
            argSourceFile.getImportList().add("standard.Exception");
            argSourceLines.add("throw new Exception("
                    + BlancoCgLineUtil.getStringLiteralEnclosure(TARGET_LANG)
                    + "[ArgumentException]: " + strClassName + "."
                    + cgMethod.getName() + " ̃p[^["
                    + cgMethod.getParameterList().size()
                    + "]łKv܂Bۂɂ["
                    + BlancoCgLineUtil.getStringLiteralEnclosure(TARGET_LANG)
                    + " . func_num_args() .  "
                    + BlancoCgLineUtil.getStringLiteralEnclosure(TARGET_LANG)
                    + "]̃p[^𔺂ČĂяo܂B"
                    + BlancoCgLineUtil.getStringLiteralEnclosure(TARGET_LANG)
                    + ");");
            argSourceLines.add(BlancoCgLineUtil.getIfEnd(TARGET_LANG));

            for (int indexParameter = 0; indexParameter < cgMethod
                    .getParameterList().size(); indexParameter++) {
                final BlancoCgParameter cgParameter = (BlancoCgParameter) cgMethod
                        .getParameterList().get(indexParameter);
                if (BlancoCgTypePhpSourceExpander
                        .isLanguageReservedKeyword(BlancoStringUtil
                                .null2Blank(cgParameter.getType().getName()))) {
                    String typeName = cgParameter.getType().getName();
                    if (typeName.equals("float")) {
                        // PHP͗jIȗRɂ floatdoubleԂƂ̂ƁB
                        // Ql: http://www.php.net/manual/ja/function.gettype.php
                        typeName = "double";
                    }
                    argSourceLines
                            .add(BlancoCgLineUtil
                                    .getIfBegin(
                                            TARGET_LANG,
                                            "gettype($"
                                                    + cgParameter.getName()
                                                    + ") !== "
                                                    + BlancoCgLineUtil
                                                            .getStringLiteralEnclosure(TARGET_LANG)
                                                    + typeName
                                                    + BlancoCgLineUtil
                                                            .getStringLiteralEnclosure(TARGET_LANG)));
                } else {
                    argSourceLines.add(BlancoCgLineUtil.getIfBegin(
                            TARGET_LANG, cgParameter.getName() + " instanceof "
                                    + cgParameter.getType().getName()
                                    + " === false"));
                }
                argSourceLines.add("throw new Exception("
                        + BlancoCgLineUtil
                                .getStringLiteralEnclosure(TARGET_LANG)
                        + "[ArgumentException]: "
                        + strClassName
                        + "."
                        + cgMethod.getName()
                        + " "
                        + (indexParameter + 1)
                        + "Ԗڂ̃p[^["
                        + cgParameter.getType().getName()
                        + "]^łȂĂ͂Ȃ܂Bۂɂ["
                        + BlancoCgLineUtil
                                .getStringLiteralEnclosure(TARGET_LANG)
                        + " "
                        + BlancoCgLineUtil
                                .getStringConcatenationOperator(TARGET_LANG)
                        + " "
                        + (BlancoCgTypePhpSourceExpander
                                .isLanguageReservedKeyword(BlancoStringUtil
                                        .null2Blank(cgParameter.getType()
                                                .getName())) ? "gettype("
                                : "get_class(")
                        + "$"
                        + cgParameter.getName()
                        + ") "
                        + BlancoCgLineUtil
                                .getStringConcatenationOperator(TARGET_LANG)
                        + " "
                        + BlancoCgLineUtil
                                .getStringLiteralEnclosure(TARGET_LANG)
                        + "]^^܂B"
                        + BlancoCgLineUtil
                                .getStringLiteralEnclosure(TARGET_LANG) + ");");
                argSourceLines.add(BlancoCgLineUtil.getIfEnd(TARGET_LANG));
            }

            argSourceLines.add("");

            // p[^̔null̓WJB
            expandParameterCheck(cgMethod, argSourceLines);

            // sWJ܂B
            expandLineList(cgMethod, argSourceLines);

            // \bhubN̏IB
            argSourceLines.add("}");
        }
    }

    /**
     * OX[WJ܂B
     * 
     * @param cgMethod
     *            \bhB
     * @param buf
     *            o̓obt@B
     */
    private void expandThrowList(final BlancoCgMethod cgMethod,
            final StringBuffer buf) {
        for (int index = 0; index < cgMethod.getThrowList().size(); index++) {
            final Object objException = cgMethod.getThrowList().get(index);
            if (objException instanceof BlancoCgException == false) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]throwsBlancoCgExceptionȊǑ^["
                        + objException.getClass().getName() + "]^܂B");
            }
            final BlancoCgException cgException = (BlancoCgException) objException;
            if (index == 0) {
                buf.append(" throws ");
            } else {
                buf.append(", ");
            }
            // hLgɂẮAblancoCgTypeɊւ鋤ʏ𗘗p邱Ƃ͂ł܂B
            // ʂɋLqs܂B
            buf.append(BlancoNameUtil.trimJavaPackage(cgException.getType()
                    .getName()));
        }
    }

    /**
     * Ame[VWJ܂B
     * 
     * @param cgMethod
     *            \bhB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandAnnotationList(final BlancoCgMethod cgMethod,
            final List argSourceLines) {
        if (cgMethod.getOverride()) {
            // Javał override̓Ame[Vŕ\܂B
            argSourceLines.add("@Override");
        }

        for (int index = 0; index < cgMethod.getAnnotationList().size(); index++) {
            final Object objAnnotation = cgMethod.getAnnotationList()
                    .get(index);
            if (objAnnotation instanceof String == false) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]Annotationjava.lang.StringȊǑ^["
                        + objAnnotation.getClass().getName() + "]^܂B");
            }

            final String strAnnotation = (String) objAnnotation;
            // JavaAnnotation @ Lq܂B
            argSourceLines.add("@" + strAnnotation);
        }
    }

    /**
     * p[^̔null̓WJB
     * 
     * @param cgMethod
     *            \bhB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandParameterCheck(final BlancoCgMethod cgMethod,
            final List argSourceLines) {
        boolean isProcessed = false;
        for (int index = 0; index < cgMethod.getParameterList().size(); index++) {
            final BlancoCgParameter cgParameter = (BlancoCgParameter) cgMethod
                    .getParameterList().get(index);
            if (cgParameter.getNotnull()) {
                isProcessed = true;

                argSourceLines
                        .add(BlancoCgLineUtil.getIfBegin(TARGET_LANG, "$"
                                + cgParameter.getName() + " === null"));
                argSourceLines.add("throw new Exception('\bh["
                        + cgMethod.getName() + "]̃p[^["
                        + cgParameter.getName()
                        + "]null^܂BÃp[^null^邱Ƃ͂ł܂B');");
                argSourceLines.add(BlancoCgLineUtil.getIfEnd(TARGET_LANG));
            }
        }

        if (isProcessed) {
            // p[^`FbNWJꂽꍇɂ͋s}܂B
            argSourceLines.add("");
        }
    }

    /**
     * sWJ܂B
     * 
     * @param cgMethod
     *            \bhB
     * @param argSourceLines
     *            o͍sXgB
     */
    private void expandLineList(final BlancoCgMethod cgMethod,
            final List argSourceLines) {
        for (int indexLine = 0; indexLine < cgMethod.getLineList().size(); indexLine++) {
            // TODO Ci[NX△NX͌_ł̓T|[gOłB

            final Object objLine = cgMethod.getLineList().get(indexLine);
            if (objLine instanceof String) {
                // java.lang.Stringɂs̓ewɂĂAe܂B
                final String strLine = (String) cgMethod.getLineList().get(
                        indexLine);
                argSourceLines.add(strLine);
            } else {
                final BlancoCgLine cgLine = (BlancoCgLine) cgMethod
                        .getLineList().get(indexLine);
                if (BlancoStringUtil.null2Blank(cgLine.getDescription())
                        .length() > 0) {
                    argSourceLines.add(BlancoCgLineUtil
                            .getSingleLineCommentPrefix(TARGET_LANG)
                            + cgLine.getDescription());
                }
                argSourceLines.add(cgLine.getValue());
            }
        }
    }
}
