/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.test.valueobject.method;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.test.valueobject.resourcebundle.BlancoValueObjectTestResourceBundle;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * ArrayList^̃tB[ĥ߂JUnitpJava\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JUnitArrayListMethod {
    private final BlancoValueObjectTestResourceBundle fBundleTest = new BlancoValueObjectTestResourceBundle();

    /**
     * \bhWJ܂B
     * 
     * @param methodName
     *            \bhB
     * @param classInfo
     *            ͂ƂȂNXB
     * @param fieldInfo
     *            ͂ƂȂtB[hB
     * @param isNameAdjust
     *            Oό`sǂB
     * @param argFactory
     *            blancoCgt@NgB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argClass
     *            o͐NXB
     */
    public void expand(final String methodName,
            final BlancoValueObjectClassStructure classInfo,
            final BlancoValueObjectFieldStructure field,
            final boolean argNameAdjust,
            final BlancoCgObjectFactory argFactory,
            final BlancoCgSourceFile argSourceFile, final BlancoCgClass argClass) {
        final BlancoCgMethod method = argFactory.createMethod(methodName,
                fBundleTest.getMethodJavadoc001(field.getName()));
        argClass.getMethodList().add(method);

        method.getThrowList().add(
                argFactory.createException("java.lang.Exception", ""));

        argSourceFile.getImportList().add("java.util.ArrayList");

        method.getLangDoc().getDescriptionList().add(
                fBundleTest.getMethodJavadoc002(classInfo.getName(), field
                        .getName(), field.getType()));

        final List listLine = method.getLineList();

        final String fieldNameAdjustered = (argNameAdjust == false ? field
                .getName() : BlancoNameAdjuster.toClassName(field.getName()));

        listLine.add(fBundleTest.getMethodBigdecimalB01L01());
        listLine.add(fBundleTest.getMethodArraylistB01L02(classInfo.getName()));
        listLine.add(fBundleTest.getMethodArraylistB01L03());

        if (field.getDefault() == null) {
            listLine.add(fBundleTest.getMethodArraylistB02L01());
            listLine.add(fBundleTest.getMethodArraylistB02L02(classInfo
                    .getName(), field.getName(), fieldNameAdjustered));
        } else {
            listLine.add(fBundleTest.getMethodArraylistB03L01());
            listLine.add(fBundleTest.getMethodArraylistB03L02(classInfo
                    .getName(), field.getName(), fieldNameAdjustered));
        }
        listLine.add(fBundleTest.getMethodArraylistB03L03());

        listLine.add(fBundleTest.getMethodArraylistB04L01());
        listLine.add(fBundleTest.getMethodArraylistB04L02(fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodArraylistB04L03(classInfo.getName(),
                field.getName(), fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodArraylistB04L04());

        listLine.add(fBundleTest.getMethodArraylistB05L01());
        listLine.add(fBundleTest.getMethodArraylistB05L02());
        listLine.add(fBundleTest.getMethodArraylistB05L03(fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodArraylistB05L04(classInfo.getName(),
                field.getName(), fieldNameAdjustered));
        listLine.add(fBundleTest.getMethodArraylistB05L05());
    }
}
