/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.IgStatement;
import blanco.ig.expander.method.MethodExpander;
import blanco.valueobject.resourcebundle.BlancoValueObjectDotNetResourceBundle;
import blanco.valueobject.util.BlancoValueObjectDotNetUtil;
import blanco.valueobject.valueobject.BlancoValueObjectDotNetClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectDotNetFieldStructure;

/**
 * blancoValueObject̎傽NXB
 * 
 * blancoValueObject\XMLt@C Java\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectDotNetXml2CsClass {
    private final BlancoValueObjectDotNetResourceBundle bundle = new BlancoValueObjectDotNetResourceBundle();

    /**
     * tB[h⃁\bh̖Oό`sǂB
     */
    private boolean fNameAdjust = true;

    /**
     * ValueObject\XMLt@C Java\[XR[h܂B
     * 
     * @param metaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param directoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File metaXmlSourceFile, final File directoryTarget)
            throws IOException {

        final DOMResult result = BlancoXmlUtil
                .transformFile2Dom(metaXmlSourceFile);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                NodeList listCommon = elementSheet
                        .getElementsByTagName("blancovalueobjectdotnet-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                Element elementCommon = (Element) listCommon.item(0);
                final String name = BlancoXmlUtil.getTextContent(elementCommon,
                        "name");
                if (name == null || name.trim().length() == 0) {
                    continue;
                }

                final BlancoValueObjectDotNetClassStructure objClassStructure = new BlancoValueObjectDotNetClassStructure();
                expandSheet(elementSheet, objClassStructure);

                /**
                 * ꂽ񂩂Java\[XR[h𐶐܂B
                 */
                processJavaSource(objClassStructure, directoryTarget);
            }
        }
    }

    public void expandSheet(final Element elementSheet,
            BlancoValueObjectDotNetClassStructure objClassStructure) {
        NodeList listCommon = elementSheet
                .getElementsByTagName("blancovalueobjectdotnet-common");
        final Element elementCommon = (Element) listCommon.item(0);
        objClassStructure.setName(BlancoXmlUtil.getTextContent(elementCommon,
                "name"));
        objClassStructure.setPackage(BlancoXmlUtil.getTextContent(
                elementCommon, "package"));
        objClassStructure.setJavadoc(BlancoXmlUtil.getTextContent(
                elementCommon, "description"));
        objClassStructure.setFilecomment(BlancoXmlUtil.getTextContent(
                elementCommon, "fileDescription"));
        objClassStructure.setListField(new ArrayList());

        if (objClassStructure.getPackage() == null) {
            throw new IllegalArgumentException(bundle
                    .getXml2csclassErr001(objClassStructure.getName()));
        }

        final NodeList listList = elementSheet
                .getElementsByTagName("blancovalueobjectdotnet-list");
        final Element elementListRoot = (Element) listList.item(0);
        final NodeList listChildNodes = elementListRoot.getChildNodes();
        for (int index = 0; index < listChildNodes.getLength(); index++) {
            if (listChildNodes.item(index) instanceof Element == false) {
                continue;
            }
            final Element elementList = (Element) listChildNodes.item(index);
            final BlancoValueObjectDotNetFieldStructure fieldStructure = new BlancoValueObjectDotNetFieldStructure();

            fieldStructure.setNo(BlancoXmlUtil
                    .getTextContent(elementList, "no"));
            fieldStructure.setName(BlancoXmlUtil.getTextContent(elementList,
                    "name"));
            if (fieldStructure.getName() == null
                    || fieldStructure.getName().trim().length() == 0) {
                continue;
            }

            fieldStructure.setType(BlancoXmlUtil.getTextContent(elementList,
                    "type"));
            fieldStructure.setJavadoc(BlancoXmlUtil.getTextContent(elementList,
                    "description"));
            fieldStructure.setDefault(BlancoXmlUtil.getTextContent(elementList,
                    "default"));
            fieldStructure.setMinLength(BlancoXmlUtil.getTextContent(
                    elementList, "minLength"));
            fieldStructure.setMaxLength(BlancoXmlUtil.getTextContent(
                    elementList, "maxLength"));
            fieldStructure.setLength(BlancoXmlUtil.getTextContent(elementList,
                    "length"));
            fieldStructure.setMinInclusive(BlancoXmlUtil.getTextContent(
                    elementList, "minInclusive"));
            fieldStructure.setMaxInclusive(BlancoXmlUtil.getTextContent(
                    elementList, "maxInclusive"));
            fieldStructure.setPattern(BlancoXmlUtil.getTextContent(elementList,
                    "pattern"));

            if (fieldStructure.getType() == null
                    || fieldStructure.getType().trim().length() == 0) {
                throw new IllegalArgumentException(bundle.getXml2csclassErr002(
                        objClassStructure.getName(), fieldStructure.getName()));
            }

            objClassStructure.getListField().add(fieldStructure);
        }
    }

    /**
     * ^ꂽNXƂJava\[XR[h܂B
     * 
     * @param classInfo
     *            NX
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    private void processJavaSource(
            final BlancoValueObjectDotNetClassStructure classInfo,
            final File directoryTarget) throws IOException {
        final ClassExpander classExpander = new ClassExpander(new IgType(
                classInfo.getPackage(), classInfo.getName())) {
            protected void expandClassStruct() {
                // o[IuWFNg͒񉻉\Ő܂B
                getCgClass().getAnnotationList().add("SerializableAttribute");

                // ftHg SystemOԂ͓܂B
                addImport(new IgType("System.String"));

                if (classInfo.getFilecomment() != null) {
                    String[] lines = BlancoValueObjectDotNetUtil
                            .escapeStringAsCsDocWithNewLine(classInfo
                                    .getFilecomment());
                    for (int index = 0; index < lines.length; index++) {
                        addFileComment(lines[index]);
                    }
                }

                if (classInfo.getJavadoc() != null) {
                    final String[] lines = BlancoValueObjectDotNetUtil
                            .escapeStringAsCsDocWithNewLine(classInfo
                                    .getJavadoc());
                    for (int index = 0; index < lines.length; index++) {
                        getJavaDoc().addLine(lines[index]);
                    }
                }

                for (int indexField = 0; indexField < classInfo.getListField()
                        .size(); indexField++) {
                    final BlancoValueObjectDotNetFieldStructure field = (BlancoValueObjectDotNetFieldStructure) classInfo
                            .getListField().get(indexField);

                    if (field.getName() == null) {
                        throw new IllegalArgumentException(bundle
                                .getXml2csclassErr003(classInfo.getName()));
                    }
                    if (field.getType() == null) {
                        throw new IllegalArgumentException(bundle
                                .getXml2csclassErr004(classInfo.getName(),
                                        field.getName()));
                    }

                    if (field.getType().equals("String")) {
                        // ܂ɂ悭ԈႢȂ̂ŁA~悤ɎdlύX܂B
                        throw new IllegalArgumentException(bundle
                                .getXml2csclassErr006(classInfo.getName(),
                                        field.getName()));
                    }

                    final String fieldNameAdjustered = (getNameAdjust() == false ? field
                            .getName()
                            : BlancoNameAdjuster.toClassName(field.getName()));

                    final FieldExpander field1 = new FieldExpander(new IgType(
                            field.getType()), "f" + fieldNameAdjustered);
                    field1.getJavaDoc().addLine(
                            bundle.getXml2csclassFieldName(field.getName()));
                    field1.getJavaDoc().addLine(
                            bundle.getXml2csclassFieldType(field.getType()));
                    if (field.getDefault() != null) {
                        field1.getJavaDoc().addLine(
                                bundle.getXml2csclassFieldDefault(field
                                        .getDefault()));
                        if ("System.String".equals(field.getType())
                                || "string".equals(field.getType())) {
                            field1.setDefaultStatement(new IgStatement("\""
                                    + BlancoJavaSourceUtil
                                            .escapeStringAsJavaSource(field
                                                    .getDefault()) + "\""));
                        } else if (field.getType().equals("bool")
                                || field.getType().equals("short")
                                || field.getType().equals("int")
                                || field.getType().equals("long")) {
                            field1.setDefaultStatement(new IgStatement(field
                                    .getDefault()));
                        } else if (field.getType().equals("System.Boolean")
                                || field.getType().equals("System.Int32")
                                || field.getType().equals("System.Int64")) {
                            field1.setDefaultStatement(new IgStatement(field
                                    .getDefault()));
                        } else if (field.getType().equals("System.Int16")) {
                            field1.setDefaultStatement(new IgStatement(field
                                    .getDefault()));
                        } else if (field.getType().equals("System.Decimal")) {
                            field1.setDefaultStatement(new IgStatement(
                                    "new Decimal(" + field.getDefault() + ")"));
                        } else if (field.getType().equals("decimal")) {
                            field1.setDefaultStatement(new IgStatement(
                                    "new decimal(" + field.getDefault() + ")"));
                        } else if (field.getType().equals(
                                "System.Collections.ArrayList")) {
                            // ArrayList̏ꍇɂ́A^ꂽ̂܂܍̗p܂B
                            addImport(new IgType("System.Collections.ArrayList"));
                            field1.setDefaultStatement(new IgStatement(field
                                    .getDefault()));
                        } else {
                            throw new IllegalArgumentException(
                                    bundle.getXml2csclassErr005(classInfo
                                            .getName(), field.getName(), field
                                            .getDefault(), field.getType()));
                        }
                    }
                    if (field.getJavadoc() != null) {
                        final String[] lines = BlancoValueObjectDotNetUtil
                                .escapeStringAsCsDocWithNewLine(field
                                        .getJavadoc());
                        for (int index = 0; index < lines.length; index++) {
                            field1.getJavaDoc().addLine(lines[index]);
                        }
                    }
                    addField(field1);

                    addMethod(new MethodExpander("Set" + fieldNameAdjustered) {
                        // \bh̃VOj`w
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    bundle.getXml2csclassSetJavadoc01(field
                                            .getName()));
                            getJavaDoc().addLine(
                                    bundle.getXml2csclassSetJavadoc02(field
                                            .getType()));
                            if (field.getJavadoc() != null) {
                                final String[] lines = BlancoValueObjectDotNetUtil
                                        .escapeStringAsCsDocWithNewLine(field
                                                .getJavadoc());
                                for (int index = 0; index < lines.length; index++) {
                                    getJavaDoc().addLine(lines[index]);
                                }
                            }

                            getJavaDoc().addParameter(
                                    "arg" + fieldNameAdjustered,
                                    bundle.getXml2csclassSetArgJavadoc(field
                                            .getName()));
                            addArgument(new IgValue(
                                    new IgType(field.getType()), "arg"
                                            + fieldNameAdjustered));
                        }

                        // \bh̎
                        public void implement() {
                            getData().addLine(
                                    "f" + fieldNameAdjustered + " = " + "arg"
                                            + fieldNameAdjustered + ";");
                        }
                    });

                    addMethod(new MethodExpander("Get" + fieldNameAdjustered) {
                        // \bh̃VOj`w
                        public void setupSignature() {
                            getJavaDoc().addLine(
                                    bundle.getXml2csclassGetJavadoc01(field
                                            .getName()));
                            getJavaDoc().addLine(
                                    bundle.getXml2csclassGetJavadoc02(field
                                            .getType()));
                            if (field.getDefault() != null) {
                                getJavaDoc()
                                        .addLine(
                                                bundle
                                                        .getXml2csclassGetArgJavadoc(field
                                                                .getDefault()));
                            }
                            if (field.getJavadoc() != null) {
                                final String[] lines = BlancoValueObjectDotNetUtil
                                        .escapeStringAsCsDocWithNewLine(field
                                                .getJavadoc());
                                for (int index = 0; index < lines.length; index++) {
                                    getJavaDoc().addLine(lines[index]);
                                }
                            }

                            getJavaDoc().addReturn(
                                    bundle.getXml2csclassGetReturnJavadoc(field
                                            .getName()));
                            setReturnType(new IgType(field.getType()));
                        }

                        // \bh̎
                        public void implement() {
                            getData().addLine(
                                    "return f" + fieldNameAdjustered + ";");
                        }
                    });
                }
            }
        };

        ClassExpander.generateCsSource(classExpander, directoryTarget);
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂݒ肵܂B
     * 
     * @param isNameAdjust
     *            Oό`sǂB
     */
    public void setNameAdjust(final boolean isNameAdjust) {
        fNameAdjust = isNameAdjust;
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂ擾܂B
     * 
     * @return Oό`sǂB
     */
    public boolean getNameAdjust() {
        return fNameAdjust;
    }
}
