/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dbmetadata.task;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import blanco.dbmetadata.BlancoDbMetaDataConstants;
import blanco.dbmetadata.csv.BlancoDbMetaDataMeta2Csv;

/**
 * ubZ[W`vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AApache Ant^XN܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoDbMetaDataMeta2CsvTask extends
        AbstractBlancoDbMetaDataMeta2CsvTask {
    /**
     * `(XLS)\[XR[hApache Ant^XÑGg|CgłB
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoDbMetaDataConstants.PRODUCT_NAME + " ("
                + BlancoDbMetaDataConstants.VERSION + ")");

        try {
            // e|fBNg쐬B
            final File fileTempDirectory = new File(getTmpdir()
                    + BlancoDbMetaDataConstants.TARGET_SUBDIRECTORY);
            fileTempDirectory.mkdirs();

            final File fileTargetDirectory = new File(getTargetdir());
            fileTargetDirectory.mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoDbMetaDataMeta2Csv().process(getJdbcdriver(),
                    getJdbcurl(), getJdbcuser(), getJdbcpassword(),
                    getSchema(), getTable(), fileTargetDirectory);
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            throw ex;
        } catch (IOException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(ex.toString());
        } catch (SQLException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(ex.toString());
        }
    }
}
