/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.java;

import java.util.List;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgException;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgLangDocTag;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgLangDoc(hLg)\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB<br>
 * NXA\bhAtB[hȂǁAe팾hLgWJ鋤ʏłB
 * 
 * @author IGA Tosiki
 */
class BlancoCgLangDocJavaSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.JAVA;

    /**
     * hLgɃ\[XR[hWJ܂B
     * 
     * @param langDoc
     *            hLgB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformLangDoc(final BlancoCgLangDoc langDoc,
            final List argSourceLines) {
        argSourceLines.add("/**");

        // JnEI{̂WJ܂B
        transformLangDocBody(langDoc, argSourceLines);

        argSourceLines.add("*/");
    }

    /**
     * hLĝA{̕WJ܂B
     * 
     * ̃\bh̓\[Xt@C̃t@Cwb_[WJpĂ܂B
     * 
     * @param langDoc
     * @param argSourceLines
     */
    public void transformLangDocBody(final BlancoCgLangDoc langDoc,
            final List argSourceLines) {
        boolean isLangDocTitleStarted = false;

        if (BlancoStringUtil.null2Blank(langDoc.getTitle()).length() > 0) {
            isLangDocTitleStarted = true;
            argSourceLines.add("* "
                    + BlancoCgSourceUtil.escapeStringAsLangDoc(TARGET_LANG,
                            langDoc.getTitle()));
        }

        // s}ς݂ǂ`FbN邽߂̃tOB
        boolean isLangDocDescriptionStarted = false;

        for (int indexDescription = 0; indexDescription < langDoc
                .getDescriptionList().size(); indexDescription++) {
            final Object objDescriptionlangDoc = langDoc.getDescriptionList()
                    .get(indexDescription);
            if (objDescriptionlangDoc instanceof String == false) {
                throw new IllegalArgumentException(
                        "BlancoCgLangDocDescriptionListjava.lang.StringȊǑ^["
                                + objDescriptionlangDoc.getClass().getName()
                                + "]ɂIuWFNgZbgĂ܂B"
                                + objDescriptionlangDoc);
            }
            final String strDescrption = (String) objDescriptionlangDoc;

            // s}B
            if (isLangDocDescriptionStarted == false) {
                isLangDocDescriptionStarted = true;
                if (isLangDocTitleStarted) {
                    argSourceLines.add("*");
                }
            }

            argSourceLines.add("* " + strDescrption);
        }

        // s}ς݂ǂ`FbN邽߂̃tOB
        boolean isLangDocTagStarted = false;

        // authorȂǕtWJB
        if (langDoc.getTagList() != null) {
            for (int index = 0; index < langDoc.getTagList().size(); index++) {
                final BlancoCgLangDocTag langDocTag = (BlancoCgLangDocTag) langDoc
                        .getTagList().get(index);

                // s}B
                if (isLangDocTagStarted == false) {
                    isLangDocTagStarted = true;
                    argSourceLines.add("*");
                }

                if (langDocTag.getName() == null) {
                    throw new IllegalArgumentException(
                            "BlancoCgLangDocTagnamenull^܂B"
                                    + langDocTag.toString());
                }
                if (langDocTag.getValue() == null) {
                    throw new IllegalArgumentException(
                            "BlancoCgLangDocTagvaluenull^܂B"
                                    + langDocTag.toString());
                }

                final StringBuffer buf = new StringBuffer();
                buf.append("* @" + langDocTag.getName() + " ");
                if (BlancoStringUtil.null2Blank(langDocTag.getKey()).length() > 0) {
                    buf.append(langDocTag.getKey() + " ");
                }
                buf.append(BlancoCgSourceUtil.escapeStringAsLangDoc(
                        TARGET_LANG, langDocTag.getValue()));
                argSourceLines.add(buf.toString());
            }
        }

        // \bhp[^WJB
        for (int indexParameter = 0; indexParameter < langDoc
                .getParameterList().size(); indexParameter++) {
            final Object objParameter = langDoc.getParameterList().get(
                    indexParameter);

            // s}B
            if (isLangDocTagStarted == false) {
                isLangDocTagStarted = true;
                argSourceLines.add("*");
            }

            // ^͊ɋlߑւɃ`FbNς݂ƑO񂵂܂B
            final BlancoCgParameter cgParameter = (BlancoCgParameter) objParameter;
            final StringBuffer bufParameter = new StringBuffer();
            bufParameter.append("* @param " + cgParameter.getName());
            if (BlancoStringUtil.null2Blank(cgParameter.getDescription())
                    .length() > 0) {
                bufParameter.append(" "
                        + BlancoCgSourceUtil.escapeStringAsLangDoc(TARGET_LANG,
                                cgParameter.getDescription()));
            }
            argSourceLines.add(bufParameter.toString());
        }

        if (langDoc.getReturn() != null
                && langDoc.getReturn().getType().getName().equals("void") == false) {

            // s}B
            if (isLangDocTagStarted == false) {
                isLangDocTagStarted = true;
                argSourceLines.add("*");
            }

            final StringBuffer bufReturn = new StringBuffer();
            bufReturn.append("* @return");
            if (BlancoStringUtil.null2Blank(
                    langDoc.getReturn().getDescription()).length() > 0) {
                bufReturn.append(" "
                        + BlancoCgSourceUtil.escapeStringAsLangDoc(TARGET_LANG,
                                langDoc.getReturn().getDescription()));
            }
            argSourceLines.add(bufReturn.toString());
        }

        // throwsXgWJB
        for (int indexThrow = 0; indexThrow < langDoc.getThrowList().size(); indexThrow++) {
            final Object objThrow = langDoc.getThrowList().get(indexThrow);

            // s}B
            if (isLangDocTagStarted == false) {
                isLangDocTagStarted = true;
                argSourceLines.add("*");
            }

            // ^͊ɋlߑւɃ`FbNς݂ƑO񂵂܂B
            final BlancoCgException cgException = (BlancoCgException) objThrow;
            final StringBuffer bufThrow = new StringBuffer();

            // hLgɂẮAblancoCgTypeɊւ鋤ʏ𗘗p邱Ƃ͂ł܂B
            // ʂɋLqs܂B
            bufThrow.append("* @throws "
                    + BlancoNameUtil.trimJavaPackage(cgException.getType()
                            .getName()));
            if (BlancoStringUtil.null2Blank(cgException.getDescription())
                    .length() > 0) {
                bufThrow.append(" "
                        + BlancoCgSourceUtil.escapeStringAsLangDoc(TARGET_LANG,
                                cgException.getDescription()));
            }
            argSourceLines.add(bufThrow.toString());
        }
    }
}
