/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilJava;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi
 */
public class CloseMethod extends BlancoDbAbstractMethod {
    public CloseMethod(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("close",
                "̃NX̃N[YȂ܂B");
        fCgClass.getMethodList().add(cgMethod);

        BlancoDbCgUtilJava.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add(
                "IɐĂJDBC\[X̃IuWFNgɑ΂ close()\bȟĂяoȂ܂B<br>");
        cgMethod.getLangDoc().getDescriptionList().add(
                "NX̗pIAK̃\bhĂяo悤ɂ܂B");

        final List listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            BlancoDbCgUtilJava.addBeginLogToMethod(cgMethod);
        }

        listLine.add("try {");
        listLine.add("if (fResultSet != null) {");
        listLine.add("fResultSet.close();");
        listLine.add("fResultSet = null;");
        listLine.add("}");
        listLine.add("} finally {");
        listLine.add("if (fStatement != null) {");
        listLine.add("fStatement.close();");
        listLine.add("fStatement = null;");
        listLine.add("}");
        listLine.add("}");
    }
}