/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.filemanager;

import blanco.plugin.filemanager.views.BlancoFileManagerDirectoryView;
import blanco.plugin.filemanager.views.BlancoFileManagerTableView;

public class BlancoFileManager {
    private static final BlancoFileManager fFileManager = new BlancoFileManager();

    private BlancoFileManagerDirectoryView fDirectoryView = null;

    private BlancoFileManagerTableView fTableView = null;

    public static BlancoFileManager getInstance() {
        return fFileManager;
    }

    public BlancoFileManagerDirectoryView getDirectoryView() {
        return fDirectoryView;
    }

    public void setDirectoryView(
            final BlancoFileManagerDirectoryView directoryView) {
        fDirectoryView = directoryView;
    }

    public BlancoFileManagerTableView getTableView() {
        return fTableView;
    }

    public void setTableView(final BlancoFileManagerTableView tableView) {
        fTableView = tableView;
    }
}
