/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.filemanager.preference;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;

/**
 * 񃊃Xĝ߂̃tB[hGfB^B
 * 
 * @author IGA Tosiki
 */
public class BlancoStringListFieldEditor extends ListEditor {
    private String fLabelText = null;

    private Composite fParent = null;

    public BlancoStringListFieldEditor(final String argName,
            final String argLabelText, final Composite argParent) {
        fLabelText = argLabelText;
        fParent = argParent;
        init(argName, argLabelText);
        createControl(argParent);
    }

    protected String createList(final String[] items) {
        StringBuffer path = new StringBuffer("");

        for (int i = 0; i < items.length; i++) {
            path.append(items[i]);
            path.append("\n");
        }
        return path.toString();
    }

    protected String[] parseString(final String argPreferenceData) {
        return splitString(argPreferenceData);
    }

    /**
     * VIuWFNg͂悤ƂꍇB
     */
    protected String getNewInputObject() {
        final InputDialog dialog = new InputDialog(getShell(), fLabelText
                + "͂܂B", fLabelText, ".*doc", new IInputValidator() {
            public String isValid(final String argText) {
                if (argText == null || argText.length() == 0) {
                    return fLabelText + "͂ĂB";
                }
                try {
                    // TODO ̏ŁA͂ꂽ͐K\ł邱ƂOƂĂ܂B

                    final Pattern patternCheck = Pattern.compile(argText);
                    patternCheck.matcher("test");

                    // ɓo^݂邩ǂ`FbNB
                    final List list = getListControl(fParent);
                    final String[] items = list.getItems();
                    for (int index = 0; index < items.length; index++) {
                        if (items[index].equals(argText)) {
                            return "w͊̕ɓo^Ă܂B";
                        }
                    }

                    return null;
                } catch (PatternSyntaxException ex) {
                    return "w͐̕K\ƂđÓł͂܂B";
                }
            }
        });

        if (dialog.open() == Dialog.OK) {
            return dialog.getValue();
        }

        // o^܂łB
        return null;
    }

    public static String[] splitString(final String argPreferenceData) {
        final StringTokenizer strTokenizer = new StringTokenizer(
                argPreferenceData, "\n");
        final ArrayList result = new ArrayList();
        while (strTokenizer.hasMoreElements()) {
            result.add(strTokenizer.nextElement());
        }
        return (String[]) result.toArray(new String[result.size()]);
    }
}
