/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.filemanager.vfs;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * Jakarta Commons VFS  Eclipse Ƃ̃C^tF[X邽߂̃NXB
 * 
 * Jakarta Commons VFS ̂߂ EditorInputNXBCommons VFS߂
 * EditorInputKvȂƂɗp܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoVfsFileObjectEditorInput implements IStorageEditorInput,
        IPathEditorInput, ILocationProvider {
    /**
     * ̃NXΏۂƂ Commons VFS FileObjectCX^XB
     */
    private FileObject fVfsFileObject = null;

    /**
     * [Nx`A_v^[̃CX^XB
     */
    private BlancoNullWorkbenchAdapter fWorkbenchAdapter = new BlancoNullWorkbenchAdapter();

    /**
     * Xg[W̃CX^XB
     */
    private IStorage fStorage;

    /**
     * pX̃CX^XB
     */
    private IPath fPath;

    /**
     * EditorInputCX^X𐶐܂B
     * 
     * @param argFile
     */
    public BlancoVfsFileObjectEditorInput(final FileObject argFile) {
        fVfsFileObject = argFile;
    }

    /**
     * ݂邩ǂB
     */
    public boolean exists() {
        try {
            return fVfsFileObject.exists();
        } catch (FileSystemException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        try {
            return getStorage().getName();
        } catch (CoreException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        try {
            return getStorage().getName();
        } catch (CoreException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    public Object getAdapter(final Class argAdapter) {
        if (ILocationProvider.class.equals(argAdapter)) {
            return this;
        }
        if (IWorkbenchAdapter.class.equals(argAdapter)) {
            return fWorkbenchAdapter;
        }

        return Platform.getAdapterManager().getAdapter(this, argAdapter);
    }

    public IPath getPath(final Object argElement) {
        if (argElement instanceof BlancoVfsFileObjectEditorInput) {
            return ((BlancoVfsFileObjectEditorInput) argElement).getPath();
        }

        return null;
    }

    public IPath getPath() {
        if (fPath == null) {
            // URLt@Co܂B
            try {
                fPath = getStorage().getFullPath();
            } catch (CoreException e) {
                // TODO ꂽ catch ubN
                e.printStackTrace();
                throw new IllegalArgumentException(e.toString());
            }
        }
        return fPath;
    }

    public boolean equals(final Object argObject) {
        if (argObject == this) {
            return true;
        }

        if (argObject instanceof BlancoVfsFileObjectEditorInput) {
            final BlancoVfsFileObjectEditorInput input = (BlancoVfsFileObjectEditorInput) argObject;
            return fVfsFileObject.equals(input.fVfsFileObject);
        }

        if (argObject instanceof IPathEditorInput) {
            final IPathEditorInput input = (IPathEditorInput) argObject;
            return getPath().equals(input.getPath());
        }

        return false;
    }

    public int hashCode() {
        return fVfsFileObject.hashCode();
    }

    public IStorage getStorage() throws CoreException {
        if (fStorage == null) {
            fStorage = new BlancoVfsFileObjectStorage(fVfsFileObject);
        }

        return fStorage;
    }

    /**
     * ܂ۂ̃[Nx`A_v^B
     * 
     * @author IGA Tosiki
     */
    private class BlancoNullWorkbenchAdapter implements IWorkbenchAdapter {
        public Object[] getChildren(final Object argObject) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(final Object argObject) {
            return null;
        }

        public String getLabel(final Object argObject) {
            return ((BlancoVfsFileObjectEditorInput) argObject).getName();
        }

        public Object getParent(final Object argObject) {
            return null;
        }
    }
}
