/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.filemanager.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class BlancoFileManagerTableLabelProvider extends LabelProvider
        implements ITableLabelProvider {
    private final NumberFormat fNumberFormat = NumberFormat.getInstance();

    private final SimpleDateFormat fDateFormat = new SimpleDateFormat(
            "yyyy/MM/dd HH:mm:ss");

    public Image getColumnImage(final Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }

        String imageKey = ISharedImages.IMG_OBJ_ELEMENT;

        // Jakarta Commons VFS
        if (element instanceof FileObject) {
            final FileObject fileLook = (FileObject) element;
            try {
                if (fileLook.getType() == FileType.FOLDER) {
                    imageKey = ISharedImages.IMG_OBJ_FOLDER;
                } else if (fileLook.getType() == FileType.FILE) {
                    imageKey = ISharedImages.IMG_OBJ_FILE;
                } else if (fileLook.getType() == FileType.IMAGINARY) {
                    // C[Wt@C̓GgƂĕ\܂B
                    imageKey = ISharedImages.IMG_OBJ_ELEMENT;
                }
            } catch (FileSystemException e) {
                // TODO ꂽ catch ubN
                e.printStackTrace();
            }
        }

        // ContentProvider
        if (element instanceof IStructuredContentProvider) {
            imageKey = ISharedImages.IMG_OBJ_FOLDER;
        }

        return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
    }

    public String getColumnText(final Object element, final int columnIndex) {
        if (element instanceof FileObject) {
            try {
                final FileObject fileLook = (FileObject) element;

                switch (columnIndex) {
                case 0:
                default: {
                    String name = fileLook.getName().getBaseName();
                    if (name.trim().length() == 0) {
                        name = fileLook.getURL().toString();
                    }
                    return name;
                }
                case 1:
                    if (fileLook.getType() == FileType.FILE) {
                        return fNumberFormat.format(fileLook.getContent()
                                .getSize());
                    } else {
                        // t@CȊO̓TCY擾ł܂B
                        return "";
                    }
                case 2:
                    return fDateFormat.format(new Date(fileLook.getContent()
                            .getLastModifiedTime()));
                }
            } catch (FileSystemException e) {
                // TODO ꂽ catch ubN
                e.printStackTrace();
            }
        }

        if (columnIndex == 0) {
            return element.toString();
        } else {
            return "(no info)";
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}
