/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.filemanager.views;

import org.apache.commons.vfs.FileObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import blanco.plugin.filemanager.BlancoFileManager;

public class BlancoFileManagerTableView extends ViewPart {
    private TableViewer viewer;

    private Action action1;

    private Action action2;

    private Action doubleClickAction;

    class NameSorter extends ViewerSorter {
    }

    /**
     * The constructor.
     */
    public BlancoFileManagerTableView() {
    }

    /**
     * This is a callback that will allow us to create the viewer and initialize
     * it.
     */
    public synchronized void createPartControl(final Composite parent) {
        // System.out.println(parent.getClass().toString());

        viewer = new TableViewer(parent, SWT.MULTI | SWT.H_SCROLL
                | SWT.V_SCROLL);

        // wb_[ݒB
        // ̏́AsetContentProvider ȂǂOɎ{Kv܂BԈĂƁA܂\܂B
        viewer.getTable().setHeaderVisible(true);
        {
            final TableColumn col = new TableColumn(viewer.getTable(),
                    SWT.CENTER);
            col.setText("Name");
            col.setWidth(300);
            final TableColumn col2 = new TableColumn(viewer.getTable(),
                    SWT.RIGHT);
            col2.setText("Size");
            col2.setWidth(180);
            final TableColumn col3 = new TableColumn(viewer.getTable(),
                    SWT.LEFT);
            col3.setText("Date");
            col3.setWidth(200);
        }

        viewer.setContentProvider(new BlancoFileManagerProvider());
        viewer.setLabelProvider(new BlancoFileManagerTableLabelProvider());
        viewer.setInput(getViewSite());

        makeActions();
        hookContextMenu();
        hookDoubleClickAction();
        contributeToActionBars();

        BlancoFileManager.getInstance().setTableView(this);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener() {
            public void menuAboutToShow(IMenuManager manager) {
                BlancoFileManagerTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        getSite().registerContextMenu(menuMgr, viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = getViewSite().getActionBars();
        fillLocalPullDown(bars.getMenuManager());
        fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(action1);
        manager.add(new Separator());
        manager.add(action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(action1);
        manager.add(action2);
        // Other plug-ins can contribute there actions here
        manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(action1);
        manager.add(action2);
    }

    private void makeActions() {
        action1 = new Action() {
            public void run() {
                showMessage("Action 1 executed");
            }
        };
        action1.setText("Action 1");
        action1.setToolTipText("Action 1 tooltip");
        action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages()
                .getImageDescriptor(ISharedImages.IMG_OBJS_INFO_TSK));

        action2 = new Action() {
            public void run() {
                showMessage("Action 2 executed");
            }
        };
        action2.setText("Action 2");
        action2.setToolTipText("Action 2 tooltip");
        action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages()
                .getImageDescriptor(ISharedImages.IMG_OBJS_INFO_TSK));
        doubleClickAction = new Action() {
            public void run() {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection) selection)
                        .getFirstElement();
                showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        viewer.addDoubleClickListener(new IDoubleClickListener() {
            public void doubleClick(DoubleClickEvent event) {
                doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation(viewer.getControl().getShell(),
                "Sample View", message);
    }

    /**
     * Passing the focus request to the viewer's control.
     */
    public synchronized void setFocus() {
        viewer.getControl().setFocus();
    }

    /**
     * fBNgݒ肵܂B
     */
    public synchronized void setDirectory(final FileObject argFileObject) {
        viewer.setInput(argFileObject);
    }
}