/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.test.valueobject;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitArrayListMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitBigDecimalMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitBooleanMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitIntegerMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitLongMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitNotSupportedMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitPrimitiveBooleanMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitPrimitiveIntMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitPrimitiveLongMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitPrimitiveShortMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitShortMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitStringMethod;
import blanco.test.valueobject.method.BlancoValueObjectXml2JUnitToStringMethod;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.resourcebundle.BlancoValueObjectResourceBundle;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

public class BlancoValueObjectXml2JUnit {
    private final BlancoValueObjectResourceBundle fBundle = new BlancoValueObjectResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * tB[h⃁\bh̖Oό`sǂB
     */
    private boolean fNameAdjust = true;

    /**
     * ValueObject\XMLt@C JUnitpJava\[XR[h܂B
     * 
     * @param metaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param directoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗OꍇB
     * @throws TransformerException
     *             XMLϊOꍇB
     */
    public void process(final File metaXmlSourceFile, final File directoryTarget)
            throws IOException, TransformerException {
        final DOMResult result = BlancoXmlUtil
                .transformFile2Dom(metaXmlSourceFile);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                final NodeList listCommon = elementSheet
                        .getElementsByTagName(fBundle
                                .getMeta2xmlElementCommon());
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);
                final String name = BlancoXmlUtil.getTextContent(elementCommon,
                        "name");
                if (name == null || name.trim().length() == 0) {
                    continue;
                }

                final BlancoValueObjectClassStructure objClassStructure = new BlancoValueObjectXml2JavaClass()
                        .parseElementSheet(elementSheet);

                /**
                 * ꂽ񂩂Java\[XR[h𐶐܂B
                 */
                processJavaSource(objClassStructure, directoryTarget);
            }
        }
    }

    /**
     * ^ꂽNXƂJava\[XR[h܂B
     * 
     * @param classInfo
     *            NX
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    private void processJavaSource(
            final BlancoValueObjectClassStructure classInfo,
            final File directoryTarget) throws IOException {
        // /testTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/test");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(classInfo.getPackage(),
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");

        fCgClass = fCgFactory.createClass(classInfo.getName() + "Test", "NX["
                + classInfo.getName() + "]̒P̎NXB");
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getExtendClassList().add(
                fCgFactory.createType("junit.framework.TestCase"));
        fCgClass.getLangDoc().getDescriptionList().add("̃NXJUnit̃eXgP[XłB");

        for (int indexField = 0; indexField < classInfo.getListField().size(); indexField++) {
            final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) classInfo
                    .getListField().get(indexField);

            if (field.getName() == null) {
                throw new IllegalArgumentException("[" + classInfo.getName()
                        + "] ŃtB[hw肳ĂȂ̂܂B");
            }
            if (field.getType() == null) {
                throw new IllegalArgumentException("[" + classInfo.getName()
                        + "] tB[h[" + field.getName()
                        + "]́u^vw肳Ă܂Bu^vw肵ĂB");
            }

            final String fieldNameAdjustered = (getNameAdjust() == false ? field
                    .getName()
                    : BlancoNameAdjuster.toClassName(field.getName()));

            if (field.getType().equals("java.lang.String")) {
                new BlancoValueObjectXml2JUnitStringMethod().expand("test"
                        + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("boolean")) {
                new BlancoValueObjectXml2JUnitPrimitiveBooleanMethod().expand(
                        "test" + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("short")) {
                new BlancoValueObjectXml2JUnitPrimitiveShortMethod().expand(
                        "test" + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("int")) {
                new BlancoValueObjectXml2JUnitPrimitiveIntMethod().expand(
                        "test" + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("long")) {
                new BlancoValueObjectXml2JUnitPrimitiveLongMethod().expand(
                        "test" + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("java.lang.Boolean")) {
                new BlancoValueObjectXml2JUnitBooleanMethod().expand("test"
                        + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("java.lang.Short")) {
                new BlancoValueObjectXml2JUnitShortMethod().expand("test"
                        + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("java.lang.Integer")) {
                new BlancoValueObjectXml2JUnitIntegerMethod().expand("test"
                        + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("java.lang.Long")) {
                new BlancoValueObjectXml2JUnitLongMethod().expand("test"
                        + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("java.math.BigDecimal")) {
                new BlancoValueObjectXml2JUnitBigDecimalMethod().expand("test"
                        + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else if (field.getType().equals("java.util.ArrayList")) {
                new BlancoValueObjectXml2JUnitArrayListMethod().expand("test"
                        + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            } else {
                new BlancoValueObjectXml2JUnitNotSupportedMethod().expand(
                        "test" + fieldNameAdjustered, classInfo, field,
                        getNameAdjust(), fCgFactory, fCgSourceFile, fCgClass);
            }
        }

        new BlancoValueObjectXml2JUnitToStringMethod().expand(classInfo,
                fCgFactory, fCgSourceFile, fCgClass);

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂݒ肵܂B
     * 
     * @param isNameAdjust
     *            Oό`sǂB
     */
    public void setNameAdjust(final boolean isNameAdjust) {
        fNameAdjust = isNameAdjust;
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂ擾܂B
     * 
     * @return Oό`sǂB
     */
    public boolean getNameAdjust() {
        return fNameAdjust;
    }
}
