/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core;

import junit.framework.TestCase;
import blanco.mail.core.valueobject.BlancoMailSetting;

public class BlancoMailReceiverTest extends TestCase {
    /**
     * T^IȐݒl擾܂B
     * 
     * @return
     */
    private BlancoMailSetting getSetting() {
        final BlancoMailSetting setting = BlancoMailSettingFactory
                .getInstance();
        if (true) {
            // ݒl BlancoMailSetting.properties 擾܂B
        } else {
            setting.setReceiveHost("localhost");
            setting.setReceiveUserName("userName");
            setting.setReceivePassword("password");
        }

        return setting;
    }

    /**
     * ̓`FbNn
     * 
     * MBMCR001
     * 
     * MBMCR101  MBMCR106
     * 
     * @throws Exception
     */
    public void testReceiveInput() throws Exception {
        try {
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            receiver.receive(null);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue(e.getMessage().indexOf("MBMCR001") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            setting.setReceiveHost(null);
            receiver.receive(setting);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue(e.getMessage().indexOf("MBMCR101") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            setting.setReceiveUserName(null);
            receiver.receive(setting);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue(e.getMessage().indexOf("MBMCR102") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            setting.setReceivePassword(null);
            receiver.receive(setting);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue(e.getMessage().indexOf("MBMCR103") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            setting.setReceiveProtocol(null);
            receiver.receive(setting);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue(e.getMessage().indexOf("MBMCR104") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            setting.setReceiveFilterBySubject("abc**");
            receiver.receive(setting);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue(e.getMessage().indexOf("MBMCR105") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailReceiver receiver = BlancoMailReceiverFactory
                    .getInstance();
            setting.setReceiveProtocol("usopop3");
            receiver.receive(setting);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue(e.getMessage().indexOf("MBMCR106") >= 0);
        }
    }
}
