/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core;

import java.io.IOException;
import java.net.ConnectException;

import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailMessageAttachment;
import blanco.mail.core.valueobject.BlancoMailSetting;

public class BlancoMailSenderSample {
    /**
     * blancoMailCorep[MTvB
     * 
     * @param args
     *            ̓p[^B
     * @throws ConnectException
     *             ڑOꍇB
     * @throws IOException
     *             [MɗOꍇB
     */
    public static void main(final String[] args) throws ConnectException,
            IOException {
        final BlancoMailSetting setting = BlancoMailSettingFactory
                .getInstance();
        if (true) {
            // ݒl BlancoMailSetting.properties 擾܂B
        } else {
            setting.setSendHost("smtp.gmail.com");
            setting.setSendPort(465);
            setting.setSendUseSsl(true);
            setting.setSendUserName("Mҁ@gmail.com");
            setting.setSendPassword("password");
            // setting.setSessionLogDirectorySuccess("./log");
            // setting.setSessionLogDirectoryError("./log.err");
        }

        final BlancoMailMessage message = new BlancoMailMessage();
        final BlancoMailAddress from = new BlancoMailAddress();
        from.setAddress(BlancoMailTestConstants.MAIL_SEND_FROM_ADDR);
        from.setPersonal("M҂̕\");
        message.setFrom(from);

        final BlancoMailAddress to1 = new BlancoMailAddress();
        to1.setAddress(BlancoMailTestConstants.MAIL_SEND_TO_ADDRS[0]);
        to1.setPersonal("M҂̕\");
        message.getTo().add(to1);

        final BlancoMailAddress to2 = new BlancoMailAddress();
        to2.setAddress(BlancoMailTestConstants.MAIL_SEND_TO_ADDRS[1]);
        to2.setPersonal("M҂̕\");
        message.getTo().add(to2);

        final BlancoMailAddress cc1 = new BlancoMailAddress();
        cc1.setAddress(BlancoMailTestConstants.MAIL_SEND_CC_ADDRS[0]);
        message.getCc().add(cc1);

        message.setSubject("[blanco] Ytt@CȂTv(BlancoMailSenderSample)");
        message.setText("ɂ́B\n悤B\n悤ȂB");

        BlancoMailSenderFactory.getInstance().send(setting, message);

        // Ytt@C
        final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
        attachment.setData("Ytt@C".getBytes());
        attachment.setFileName("aaa.txt");
        message.getAttachmentList().add(attachment);

        final BlancoMailMessageAttachment attachment2 = new BlancoMailMessageAttachment();
        attachment2.setData("Ytt@C2".getBytes());
        attachment2.setFileName("Ytt@CQ.txt");
        message.getAttachmentList().add(attachment2);

        message.setSubject("Ytt@CTv(BlancoMailSenderSample)");
        message.setText("ɂ́B\n悤B\n悤ȂB");

        BlancoMailSenderFactory.getInstance().send(setting, message);
    }
}
