/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.message;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.message.message.BlancoMessageMessage;
import blanco.message.valueobject.BlancoMessageFieldStructure;
import blanco.message.valueobject.BlancoMessageStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * ubZ[W`vExcell𒊏o܂B
 * 
 * ̃NX́AXMLt@C񒊏o@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoMessageXmlParser {
    /**
     * bZ[W`B
     */
    protected final BlancoMessageMessage fMsg = new BlancoMessageMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public BlancoMessageStructure[] parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoMessageStructure[] parse(final BlancoXmlDocument argXmlDocument) {
        final ArrayList listStructure = new ArrayList();
        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            final List listCommon = BlancoXmlBindingUtil.getElementsByTagName(
                    elementSheet, "blancomessage-common");
            if (listCommon.size() == 0) {
                // commonꍇɂ̓XLbv܂B
                continue;
            }

            // ŏ̃ACêݏĂ܂B
            final BlancoXmlElement elementCommon = (BlancoXmlElement) listCommon
                    .get(0);
            final BlancoMessageStructure structure = parseElementSheet(
                    elementSheet, elementCommon);
            if (structure != null) {
                // ꂽL܂B
                listStructure.add(structure);
            }
        }

        final BlancoMessageStructure[] result = new BlancoMessageStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoMessageStructure parseElementSheet(
            final BlancoXmlElement argElementSheet,
            final BlancoXmlElement argElementCommon) {
        final BlancoMessageStructure structure = new BlancoMessageStructure();
        // ̓p[^擾܂B

        // V[gڍׂȏ擾܂B
        structure.setName(BlancoXmlBindingUtil.getTextContent(argElementCommon,
                "name"));
        structure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (BlancoStringUtil.null2Blank(structure.getName()).length() == 0) {
            return null;
        }

        if (BlancoStringUtil.null2Blank(structure.getPackage()).trim().length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbmsgi01(structure
                    .getName()));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            structure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "suffix") != null) {
            structure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "suffix"));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "idEmbedding") != null) {
            structure.setIdEmbedding("true".equals(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "idEmbedding")));
        }

        final BlancoXmlElement elementMessageList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancomessage-list");
        if (elementMessageList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List listField = BlancoXmlBindingUtil.getElementsByTagName(
                elementMessageList, "field");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final Object nodeField = listField.get(indexField);
            if (nodeField instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementField = (BlancoXmlElement) nodeField;

            final BlancoMessageFieldStructure fieldStructure = new BlancoMessageFieldStructure();

            fieldStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                    elementField, "no"));
            fieldStructure.setName(BlancoXmlBindingUtil.getTextContent(
                    elementField, "key"));
            if (BlancoStringUtil.null2Blank(fieldStructure.getName()).length() == 0) {
                // keyw肳ĂȂꍇɂ͏܂B
                continue;
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(elementField, "value"))
                    .length() > 0) {
                fieldStructure.setMessage(BlancoXmlBindingUtil.getTextContent(
                        elementField, "value"));
            }

            if (BlancoStringUtil.null2Blank(fieldStructure.getMessage())
                    .length() == 0) {
                // ŌxB
                continue;
            }

            // ɓeo^ĂȂǂ̃`FbNB
            for (int indexPast = 0; indexPast < structure.getFieldList().size(); indexPast++) {
                final BlancoMessageFieldStructure fieldPast = (BlancoMessageFieldStructure) structure
                        .getFieldList().get(indexPast);
                if (fieldPast.getName().equals(fieldStructure.getName())) {
                    throw new IllegalArgumentException(fMsg.getMbmsgi03(
                            structure.getName(), fieldStructure.getName()));
                }
            }

            structure.getFieldList().add(fieldStructure);
        }

        return structure;
    }
}
