/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.text.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;

/**
 * u\[XeLXgv include R}h܂B
 * 
 * ̏͂PpXڂŎs܂B
 */
public class BlancoTextConverterSrcTxtPreCmdInclude implements
        BlancoTextConverterSrcTxtPreCmd {
    /**
     * łR}hǂ𔻒肵܂B
     * 
     * @param argCommandLine
     * @throws IOException
     * 
     */
    public boolean canExecute(final String argCommandLine) throws IOException {
        // include Ŏn܂邩ǂ𔻒B
        if (argCommandLine.startsWith("include,")) {
            return true;
        }
        return false;
    }

    /**
     * R}hs܂B
     * 
     * @param strCommand
     * @param argWriter
     */
    public void execute(final String strCommand, final BufferedWriter argWriter)
            throws IOException {
        Logger.getLogger("blanco.text.converter").finest(
                "R}h[" + strCommand.toString() + "]");

        final BufferedReader reader = new BufferedReader(new InputStreamReader(
                new FileInputStream(strCommand.substring("include,".length()))));
        try {
            BlancoTextConverterSrcTxtUtil.copy(reader, argWriter);
        } finally {
            reader.close();
        }
    }
}
