/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.text.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * u\[XeLXgvR}hp[X܂B̃NX𗘗pƃ[_SĂǂݍ݂܂B
 */
public final class BlancoTextConverterSrcTxtCmdProcessor {
    protected List fCmdList = new ArrayList();

    public void addCommand(final BlancoTextConverterSrcTxtCmd argCommand) {
        fCmdList.add(argCommand);
    }

    public final void execute(final BufferedReader reader,
            final BufferedWriter writer) throws IOException {
        if (fCmdList.size() == 0) {
            throw new IllegalArgumentException("ЂƂR}ho^Ă܂B");
        }

        int startCounter = 0;
        for (;;) {
            final int iRead = reader.read();
            if (iRead < 0) {
                break;
            }

            if (iRead == '[') {
                startCounter++;
                if (startCounter >= 2) {
                    // R}hJnB
                    startCounter = 0;
                    parseCommand(reader, writer);
                } else {
                    // ȂB
                }
            } else {
                if (startCounter > 0) {
                    // ߂ĂAoB
                    for (; startCounter > 0; startCounter--) {
                        writer.write('[');
                    }
                }

                writer.write(iRead);
            }
        }
    }

    /**
     * [[ŃR}hJnꂽƔfƂɓĂ܂B
     * 
     * @param reader
     * @param writer
     * @throws IOException
     */
    private void parseCommand(final BufferedReader reader,
            final BufferedWriter writer) throws IOException {
        final StringBuffer strbuf = new StringBuffer();
        int endCounter = 0;
        for (;;) {
            final int iRead = reader.read();
            if (iRead < 0) {
                break;
            }

            if (iRead == ']') {
                endCounter++;
                if (endCounter >= 2) {
                    // R}hIB
                    break;
                } else {
                    // ȂB
                }
            } else {
                if (endCounter > 0) {
                    // ߂ĂAoB
                    for (; endCounter > 0; endCounter--) {
                        strbuf.append(']');
                    }
                }
                strbuf.append((char) iRead);
            }
        }

        if (processCommand(strbuf.toString(), writer)) {
            // ̂Ō㑱͕svB
        } else {
            // oĂ߂܂B
            writer.write("[[");
            writer.write(strbuf.toString());
            writer.write("]]");
        }
    }

    /**
     * ̓IȏB
     * 
     * @param strCommand
     * @param argWriter
     * @return ̃R}htrueBȂfalseB
     * @throws IOException
     */
    boolean processCommand(final String strCommand,
            final BufferedWriter argWriter) throws IOException {
        for (int index = 0; index < fCmdList.size(); index++) {
            final BlancoTextConverterSrcTxtCmd cmd = (BlancoTextConverterSrcTxtCmd) fCmdList
                    .get(index);
            if (cmd.canExecute(strCommand.toString()) == true) {
                cmd.execute(strCommand, null, argWriter);
                return true;
            }
        }

        return false;
    }
}
