package blanco.text.converter;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;

public class BlancoTextConverterSrcTxtUtil {
    public static void copy(final Reader reader, final Writer writer)
            throws IOException {
        final char[] buf = new char[8192];
        for (;;) {
            final int length = reader.read(buf, 0, buf.length);
            if (length < 0) {
                break;
            }
            writer.write(buf, 0, length);
        }
    }

    public static String getFirstCommandLine(final String line,
            final int startPos) {
        // TODO ܂ [[]]̉͂Ȃ܂BdvB
        final int posCmdStart = line.indexOf("[[", startPos);
        int posCmdEnd = 0;
        if (posCmdStart >= 0) {
            for (;;) {
                posCmdEnd = line.indexOf("]]", posCmdEnd);
                if (posCmdEnd < 0) {
                    // I
                    break;
                }
                if (posCmdStart < posCmdEnd) {
                    // 
                    break;
                }
            }
        } else {
            posCmdEnd = -1;
        }

        if (posCmdEnd > 0) {
            return line.substring(posCmdStart + 2, posCmdEnd);
        } else {
            return null;
        }
    }

    public static String getCommandName(final String commandLine) {
        StringTokenizer token = new StringTokenizer(commandLine, ",");
        if (token.hasMoreTokens()) {
            return token.nextToken();
        }
        // K null ȊO߂܂B
        return "";
    }

    public static String getPairEndCommandName(final String commandName) {
        if (commandName.endsWith("-begin")) {
            // ΉÂ-end܂ŒT܂B
            final String endCommand = commandName.substring(0, commandName
                    .length()
                    - "-begin".length())
                    + "-end";
            return endCommand;
        } else {
            // ̂悤Ȃ̂͂܂B
            return null;
        }
    }
}
