/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.util;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

public class UnMnemonicProperties
extends Properties {
    private static final long serialVersionUID = -4066795589235888438L;
    public static final String MNEMONIC_CHARS = "[\\w\\.@]";

    public UnMnemonicProperties() {
    }

    public UnMnemonicProperties(String path) {
        this(FileSystem.getResourceFile(path));
    }

    public UnMnemonicProperties(File root) {
        if (root.isDirectory()) {
            Object[] files = root.listFiles();
            Arrays.sort(files);
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (((File)file).isFile() && ((File)file).getName().endsWith(".properties")) {
                    Properties prop = FileSystem.loadProperties((File)file);
                    this.putAll((Map<?, ?>)prop);
                }
                ++n2;
            }
        } else {
            Properties prop = FileSystem.loadProperties(root);
            this.putAll((Map<?, ?>)prop);
        }
    }

    public synchronized Object put(Object key, Object value) {
        return super.put(this.removeMnemonic(key), this.removeMnemonic(value));
    }

    private String removeMnemonic(Object value) {
        String strValue = value.toString();
        strValue = strValue.replaceFirst("\\(\\&[\\w\\.@]\\)", "");
        strValue = strValue.replaceFirst("\\(\\&\\)", "");
        strValue = UnMnemonicProperties.removeEnMnemonic(strValue);
        return strValue;
    }

    public static String removeEnMnemonic(String enValue) {
        if (UnMnemonicProperties.hasEnMnemonic(enValue)) {
            return enValue.replaceFirst("\\&([\\w\\.@])", "$1");
        }
        return enValue;
    }

    public static boolean hasJaMnemonic(String value) {
        return value.matches("(?s)^.*?\\(\\&[\\w\\.@]\\).*$");
    }

    public static boolean hasEnMnemonic(String value) {
        return value.contains("&") && !value.contains("&lt;") && !value.contains("&gt;") && !value.contains("&amp;") && !value.contains("&quot;") && !value.contains("K&R ");
    }
}

