/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import blanco.commons.util.BlancoStreamUtil;
import blanco.nlpack.generator.resourcebundle.BlancoNLpackGeneratorResourceBundle;
import blanco.nlpack.generator.valueobject.BlancoNLpackGeneratorManifest;

/**
 * blancoNLpackGeneratorœIɗp郆[eBeBNXB
 * 
 * @author IGA Tosiki
 */
public class BlancoNLpackGeneratorUtil {
    private static final BlancoNLpackGeneratorResourceBundle fBundle = new BlancoNLpackGeneratorResourceBundle();

    /**
     * vOC .nlja  o[Wԍt^̂擾܂B
     * 
     * @param manifest
     *            }jtFXgB
     * @return TtBbNXtvOCB
     */
    public static String getPluginNameWithSuffix(
            final BlancoNLpackGeneratorManifest manifest) {
        return manifest.getBundleSymbolicName() + "."
                + fBundle.getSymbolicNameSuffix() + "_"
                + manifest.getBundleVersion();
    }

    /**
     * vOC̃t̂V{bNސ܂B
     * 
     * @param pluginFullName
     *            vOC̃t́B
     * @return V{bNB
     */
    public static String getBundleSymbolicName(final String pluginFullName) {
        // |CgBA_[o[ŕB
        final int underLine = pluginFullName.indexOf('_');
        if (underLine < 0) {
            throw new IllegalArgumentException("s\: getBundleSymbolicName("
                    + pluginFullName + ")");
        }
        return pluginFullName.substring(0, underLine);
    }

    /**
     * vOC̃t̂o[Wސ܂B
     * 
     * @param pluginFullName
     *            vOC̃t́B
     * @return o[WB
     */
    public static String getBundleVersion(final String pluginFullName) {
        // |CgBA_[o[ŕB
        final int underLine = pluginFullName.indexOf('_');
        if (underLine < 0) {
            throw new IllegalArgumentException("s\: getBundleVersion("
                    + pluginFullName + ")");
        }
        return pluginFullName.substring(underLine + 1);
    }

    /**
     * }jtFXg URI𐶐܂B
     * 
     * @param manifest
     *            }jtFXgB
     * @param strPropertyFilePath
     *            vpeBt@C̃pXB(}jtFXg猈łȂꍇɗp)
     * @return URIB
     * @throws IOException
     *             o͗OꍇB
     */
    public static String getBabelURI(BlancoNLpackGeneratorManifest manifest,
            final String strPropertyFilePath) throws IOException {
        // TODO o[W𖄂ߍނȂǂ̍l@B
        // : babel://V{:o[W/vpeBt@C̃pX
        return "babel://" + manifest.getBundleSymbolicName() + "/"
                + strPropertyFilePath;
    }

    /**
     * ̓Xg[SēǂݍŃoCgz񉻂܂B
     * 
     * @param inStream
     *            ̓Xg[B
     * @return oCgz񉻂ꂽSf[^B
     * @throws IOException
     *             o͗OꍇB
     */
    public static byte[] readBytes(final InputStream inStream)
            throws IOException {
        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        BlancoStreamUtil.copy(inStream, outStream);
        outStream.flush();
        outStream.close();
        return outStream.toByteArray();
    }
}
