/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.nlpack.generator.csv.io;

import java.io.BufferedWriter;
import java.io.IOException;

import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorDiffResultDetailCsvRecord;
import blanco.nlpack.generator.csv.util.BlancoCsvRuntimeUtil;

/**
 * t@C`[BlancoNLpackGeneratorDiffResultDetail/blancoNLpackGenerator  ResultDetail ̍킷CSVt@CB]̃C^NX
 *
 * ̃NXblancoCsvt@C`玩ꂽC^NXłB<br>
 * @1.񒷃`FbNɂ́AftHgGR[fBO𗘗p܂B<br>
 * @2.NX̗p͕K close()ĂяoĂB<br>
 */
public class BlancoNLpackGeneratorDiffResultDetailCsvWriter {
    /**
     * C^IuWFNg
     *
     * IɎۂɏo͂s̃C^L܂B
     */
    private BufferedWriter fWriter;

    /**
     * ̍sJE^
     *
     * ݏsĂs̈ʒuL܂B
     */
    private long fLineCounter = 0;

    /**
     * CSVC^NX̃RXgN^
     *
     * ^ꂽC^ƘA܂B
     *
     * @param arg A郉C^
     */
    public BlancoNLpackGeneratorDiffResultDetailCsvWriter(final BufferedWriter arg) {
        fWriter = arg;
    }

    /**
     * CSVt@C̃^Cgso܂
     *
     * ^Cg̓f~^ŋ؂Ȃ烉C^ɏo͂AŌɉsR[ht^܂B<br>
     * ^Cg̓_uNI[e[Vň͂܂܂B
     *
     * @throws IOException AꂽC^[o͂̍ۂɗOꍇB
     */
    public void writeTitle() throws IOException {
        fWriter.write("\"URI\"");
        fWriter.write(",\"Diff\"");
        fWriter.write(",\"Key\"");
        fWriter.write(",\"LeftAction\"");
        fWriter.write(",\"LeftInput\"");
        fWriter.write(",\"LeftOutput\"");
        fWriter.write(",\"RightAction\"");
        fWriter.write(",\"RightInput\"");
        fWriter.write(",\"RightOutput\"");
        fWriter.newLine();
    }

    /**
     * ^ꂽso܂
     *
     * f[^̓f~^ŋ؂Ȃ烉C^ɏo͂AŌɉsR[ht^܂B
     *
     * @param record R[hIuWFNg
     * @throws BlancoCsvIOException ^ꂽR[h̍ڒlsȏꍇȂǁB
     * @throws IOException AꂽC^[o͂̍ۂɗOꍇB
     */
    public void writeRecord(final BlancoNLpackGeneratorDiffResultDetailCsvRecord record) throws BlancoCsvIOException, IOException {
        String writeToken = null;

        // ڔԍ[1] ږ[BundleUri/URI]
        if (record.getBundleUri() == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[BundleUri/URI]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        if (record.getBundleUri().length() == 0) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[BundleUri/URI]̏ɂĕK{ڂɒ0̕񂪗^Ă邱Ƃm܂B");
        }
        writeToken = record.getBundleUri();
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[BundleUri/URI]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[2] ږ[Diff/Diff]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getDiff() == null ? "" : record.getDiff();
        if (writeToken.length() > 0) {
            if (writeToken.getBytes().length < 3) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 2ږځBڔԍ[2] ږ[Diff/Diff]̏ɂMIN(3)Zl[" + writeToken + "]m܂B");
            }
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[3] ږ[Key/Key]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getKey() == null ? "" : record.getKey();
        if (writeToken.length() > 0) {
            if (writeToken.getBytes().length < 1) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 3ږځBڔԍ[3] ږ[Key/Key]̏ɂMIN(1)Zl[" + writeToken + "]m܂B");
            }
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[4] ږ[LeftAction/LeftAction]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getLeftAction() == null ? "" : record.getLeftAction();
        if (writeToken.length() > 0) {
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[5] ږ[LeftInput/LeftInput]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getLeftInput() == null ? "" : record.getLeftInput();
        if (writeToken.length() > 0) {
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[6] ږ[LeftOutput/LeftOutput]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getLeftOutput() == null ? "" : record.getLeftOutput();
        if (writeToken.length() > 0) {
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[7] ږ[RightAction/RightAction]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getRightAction() == null ? "" : record.getRightAction();
        if (writeToken.length() > 0) {
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[8] ږ[RightInput/RightInput]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getRightInput() == null ? "" : record.getRightInput();
        if (writeToken.length() > 0) {
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[9] ږ[RightOutput/RightOutput]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getRightOutput() == null ? "" : record.getRightOutput();
        if (writeToken.length() > 0) {
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));

        // ŌɉsR[ht^܂B
        fWriter.newLine();
        fLineCounter++;
    }

    /**
     * IɕێĂ郉C^Ԃ܂B
     *
     * @return IɕێĂ郉C^B
     */
    public BufferedWriter getWriter() {
        return fWriter;
    }

    /**
     * ݏ̍sJE^Ԃ܂B
     *
     * @return ݏ̍sJE^B
     */
    public long getLineCounter() {
        return fLineCounter;
    }

    /**
     * ̃C^tbV܂B
     *
     * ֘AÂĂC^ɑ΂Ăflush()Ăяo܂B
     *
     * @throws IOException ֘AÂĂC^flush()ɎsꍇB
     */
    public void flush() throws IOException {
        fWriter.flush();
    }

    /**
     * ̃C^܂B
     *
     * ֘AÂĂC^ɑ΂Ăclose()Ăяo܂B
     *
     * @throws IOException ֘AÂĂC^close()ɎsꍇB
     */
    public void close() throws IOException {
        fWriter.close();
    }
}
