/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

import blanco.commons.io.Native2AsciiWriter;
import blanco.commons.util.BlancoStringUtil;
import blanco.nlpack.generator.csv.io.BlancoCsvIOException;
import blanco.nlpack.generator.csv.io.BlancoNLpackGeneratorResultDetailCsvWriter;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultDetailCsvRecord;
import blanco.nlpack.generator.dictionary.BlancoNLpackGeneratorOmitDictionary;
import blanco.nlpack.generator.dictionary.BlancoNLpackGeneratorPleiadesDictionary;
import blanco.nlpack.generator.message.BlancoNLpackGeneratorMessage;
import blanco.nlpack.generator.resourcebundle.BlancoNLpackGeneratorResourceBundle;

/**
 * vpeBt@CA[_EC^oR(pꂩ)eւƒlϊ܂B
 * 
 * @author IGA Tosiki
 */
class BlancoNLpackGeneratorPropertiesConverter {
    /**
     * bZ[WIuWFNgB
     */
    private final BlancoNLpackGeneratorMessage fMsg = new BlancoNLpackGeneratorMessage();

    /**
     * vOŗp郊\[XohB
     */
    private final BlancoNLpackGeneratorResourceBundle fBundle = new BlancoNLpackGeneratorResourceBundle();

    /**
     * Pleiades̃CX^XB
     */
    private BlancoNLpackGeneratorPleiadesDictionary fDictionary = new BlancoNLpackGeneratorPleiadesDictionary();

    /**
     * blancoNLpackGeneratorƂĂ̏OCX^XB
     */
    private BlancoNLpackGeneratorOmitDictionary fOmitDictionary = new BlancoNLpackGeneratorOmitDictionary();

    /**
     * qbgB
     */
    private int fReplaceHitCount = 0;

    /**
     * j[jbNϊB
     */
    private int fReplaceMnemonicCount = 0;

    /**
     * OB
     */
    private int fReplaceOmitCount = 0;

    /**
     * ~XB
     */
    private int fReplaceMissCount = 0;

    /**
     * ڍ׃OC^B
     */
    private BlancoNLpackGeneratorResultDetailCsvWriter fLogDetailWriter = null;

    /**
     * qbg擾܂B
     * 
     * @return qbgB
     */
    public int getReplaceHitCount() {
        return fReplaceHitCount;
    }

    /**
     * j[jbNϊ擾܂B
     * 
     * @return j[jbNϊB
     */
    public int getReplaceMnemonicCount() {
        return fReplaceMnemonicCount;
    }

    /**
     * O擾܂B
     * 
     * @return OB
     */
    public int getReplaceOmitCount() {
        return fReplaceOmitCount;
    }

    /**
     * ~X擾܂B
     * 
     * @return ~XB
     */
    public int getReplaceMissCount() {
        return fReplaceMissCount;
    }

    public void setLogDetailWriter(
            final BlancoNLpackGeneratorResultDetailCsvWriter arg) {
        fLogDetailWriter = arg;
    }

    /**
     * vpeBt@C[_œǂݍ݁Aϊ\ȕ͉pꁨeϊsăC^ɏo͂܂B
     * 
     * @param bundleURI
     *            ohURIB
     * @param props
     *            vpeBB
     * @param reader
     *            [_B
     * @param writer
     *            C^B
     * @return uǂB
     * @throws IOException
     *             o͗OꍇB
     */
    public boolean process(final String bundleURI, final Properties props,
            final BufferedReader reader, final BufferedWriter writer)
            throws IOException {
        // Ăяo邲ƂɃJE^Zbg܂B
        fReplaceHitCount = 0;
        fReplaceMnemonicCount = 0;
        fReplaceOmitCount = 0;
        fReplaceMissCount = 0;

        if (BlancoStringUtil.null2Blank(fBundle.getPropertiesHeader()).length() > 0) {
            // lHIɃwb_[t^܂B
            writer.write(fBundle.getPropertiesHeader());
            writer.newLine();
            writer.newLine();
        }

        boolean isReplaced = false;
        for (;;) {
            outerLoop: {
                final String line = reader.readLine();
                if (line == null) {
                    break;
                }

                if (line.trim().startsWith("#") || line.trim().startsWith("!")
                        || line.trim().length() == 0) {
                    writer.write(line);
                    writer.newLine();
                    continue;
                }

                final StringBuffer strbufKey = new StringBuffer();

                StringReader readerLine = new StringReader(line);
                for (;;) {
                    final int iRead = readerLine.read();
                    if (iRead < 0) {
                        writer.newLine();
                        break outerLoop;
                    }
                    // ڏB
                    writer.write(iRead);
                    if (iRead == '=') {
                        // ӒlI
                        break;
                    }
                    strbufKey.append((char) iRead);
                }

                // ͉EӒl

                boolean isEscapeStarted = false;
                final StringWriter writerLine = new StringWriter();
                for (boolean isValueStarted = false;;) {
                    final int iRead = readerLine.read();
                    if (iRead < 0) {
                        if (isEscapeStarted) {
                            // GXP[vȂ̂ɍsɗĂ܂܂B
                            final String line2 = reader.readLine();
                            if (line2 == null) {
                                break;
                            }
                            isEscapeStarted = false;
                            readerLine = new StringReader(line2);
                            continue;
                        }
                        break;
                    }
                    if (isValueStarted == false && iRead == ' ') {
                        continue;
                    }
                    isValueStarted = true;

                    if (iRead == '\\') {
                        if (isEscapeStarted == false) {
                            isEscapeStarted = true;
                        } else {
                            writerLine.write("\\\\");
                            isEscapeStarted = false;
                        }
                    } else {
                        if (isEscapeStarted) {
                            isEscapeStarted = false;
                            writerLine.write('\\');
                        }
                        // obt@B
                        writerLine.write(iRead);
                    }
                }

                readerLine.close();
                writerLine.close();

                // 擾ꂽL[ƂɎЂ܂B

                // key \ 邱Ƃ̍ltŕ擾܂B
                final String strKey = getKeyWithEscape(strbufKey.toString()
                        .trim());

                final String inputValue = (String) props.get(strKey);
                if (inputValue == null) {
                    throw new IllegalArgumentException(fMsg.getMbebc002(
                            bundleURI, strKey));
                }

                final BlancoNLpackGeneratorResultDetailCsvRecord record = new BlancoNLpackGeneratorResultDetailCsvRecord();

                if (lookup(bundleURI, strKey, inputValue, writer, record)) {
                    isReplaced = true;
                }

                writer.newLine();

                try {
                    fLogDetailWriter.writeRecord(record);
                } catch (BlancoCsvIOException e) {
                    // TOOD ObZ[W̔ԁB
                    throw new IOException(e.toString());
                }
            }
        }
        return isReplaced;
    }

    /**
     * Ђ܂B
     * 
     * @param bundleURI
     * @param strKey
     * @param inputValue
     * @param writer
     * @param record
     * @return
     * @throws IOException
     */
    private boolean lookup(final String bundleURI, final String strKey,
            final String inputValue, final BufferedWriter writer,
            final BlancoNLpackGeneratorResultDetailCsvRecord record)
            throws IOException {
        final String bundleURIwithKey = bundleURI + "?key=" + strKey;

        record.setBundleUri(bundleURIwithKey);
        record.setKey(strKey);
        record.setInput(inputValue);

        final String outputValue = fDictionary.lookup(inputValue);
        if (outputValue == null) {
            throw new IllegalArgumentException(fMsg.getMbebc003(bundleURI,
                    strKey));
        }

        if (fOmitDictionary.checkOmitURI(bundleURI)
                || fOmitDictionary.checkOmitURI(bundleURIwithKey)) {
            // URIx[XomitŏOΏۂƂ킩ꍇB

            // ͂ꂽvaluê܂܏óB
            writer
                    .write(Native2AsciiWriter
                            .encodeNative2AsciiValue(inputValue));
            fReplaceOmitCount++;
            record.setAction("omit.u");
            return false;
        }

        if (fOmitDictionary.checkOmitPhrase(inputValue)) {
            // 񂾂ꍇɃt[YOΏۂƂ킩ꍇB

            // ͂ꂽvaluê܂܏óB
            writer
                    .write(Native2AsciiWriter
                            .encodeNative2AsciiValue(inputValue));
            fReplaceOmitCount++;
            record.setAction("omit.p");
            return false;
        }

        if (fOmitDictionary.checkOmitString(inputValue)) {
            // 񂾂ꍇɏOΏۂƂ킩ꍇB

            // ͂ꂽvaluê܂܏óB
            writer
                    .write(Native2AsciiWriter
                            .encodeNative2AsciiValue(inputValue));
            fReplaceOmitCount++;
            record.setAction("omit.s");
            return false;
        }

        if (fDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_NOT_FOUND) {
            // ɌȂꍇB

            // ͂ꂽvaluê܂܏óB
            writer
                    .write(Native2AsciiWriter
                            .encodeNative2AsciiValue(inputValue));
            fReplaceMissCount++;
            record.setAction("miss");
            return false;
        }

        if (fDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_MNEMONIC_CHANGED) {
            // j[jbNϊ̂ݎ{ꂽꍇB

            if (fOmitDictionary.checkOmitMnemonicOnlyURI(bundleURI)
                    || fOmitDictionary
                            .checkOmitMnemonicOnlyURI(bundleURIwithKey)) {
                // j[jbNϊ݂̂̏Ot@CɍvꍇB

                // ͕ϊĂ̓_B
                // ͂ꂽvaluê܂܏óB
                writer.write(Native2AsciiWriter
                        .encodeNative2AsciiValue(inputValue));
                fReplaceOmitCount++;
                record.setAction("omit.m");
                return false;
            }

            // o͒lZbgI
            writer.write(Native2AsciiWriter
                    .encodeNative2AsciiValue(outputValue));
            fReplaceMnemonicCount++;
            // u}[NB
            record.setAction("mnemon");
            record.setOutput(outputValue);
            return true;
        }

        if (fDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_FOUND) {
            // ̈ĂɐꍇB

            // o͒lZbgI
            writer.write(Native2AsciiWriter
                    .encodeNative2AsciiValue(outputValue));
            fReplaceHitCount++;
            // u}[NB
            record.setAction("hit");
            record.setOutput(outputValue);
            return true;
        }

        throw new IllegalArgumentException("z肳ȂӏɓĂ܂B");
    }

    /**
     * GXP[vlȂL[l擾܂B
     * 
     * @param input
     * @return
     * @throws IOException
     */
    private String getKeyWithEscape(final String input) throws IOException {
        final Properties prop = new Properties();
        prop.load(new ByteArrayInputStream(new String(input + "=dummy")
                .getBytes("UTF-8")));
        final Set set = prop.keySet();
        final Iterator ite = set.iterator();
        if (ite.hasNext() == false) {
            throw new IllegalArgumentException("");
        }
        return (String) ite.next();
    }
}
