/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.manifest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Map.Entry;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import blanco.nlpack.generator.BlancoNLpackGeneratorUtil;
import blanco.nlpack.generator.message.BlancoNLpackGeneratorMessage;
import blanco.nlpack.generator.valueobject.BlancoNLpackGeneratorManifest;

/**
 * }jtFXg ([MANIFEST.MF]t@C) ǂݍރNXB
 * 
 * @author IGA Tosiki
 */
public class BlancoNLpackGeneratorManifestReader {
    /**
     * bZ[WIuWFNgB
     */
    private final BlancoNLpackGeneratorMessage fMsg = new BlancoNLpackGeneratorMessage();

    /**
     * ^ꂽ ManifestNX }jtFXgǂݍ݂܂B
     * 
     * @param manifest
     *            ManifestNX̃CX^XB
     * @return Manifesto[IuWFNgB
     * @throws IOException
     *             o͗OꍇB
     */
    public BlancoNLpackGeneratorManifest read(final Manifest manifest)
            throws IOException {
        final BlancoNLpackGeneratorManifest result = new BlancoNLpackGeneratorManifest();

        final Attributes attrs = manifest.getMainAttributes();
        if (attrs == null) {
            throw new IllegalArgumentException(fMsg.getMbebmr01(manifest
                    .toString()));
        }

        for (Iterator ite = attrs.entrySet().iterator(); ite.hasNext();) {
            final Entry entry = (Entry) ite.next();

            final Attributes.Name name = (Attributes.Name) entry.getKey();
            if ("Bundle-Version".equals(name.toString())) {
                result.setBundleVersion(entry.getValue().toString());
            }
            if ("Bundle-SymbolicName".equals(name.toString())) {
                // V{ɂ ;܂܂ꍇAB
                result.setBundleSymbolicName(getValueWithoutOption(entry
                        .getValue().toString()));
            }
            if ("Bundle-Name".equals(name.toString())) {
                result.setBundleName(entry.getValue().toString());
            }
            if ("Bundle-Vendor".equals(name.toString())) {
                result.setBundleVendor(entry.getValue().toString());
            }

            // TODO KvɉāÃL[ђlǂݍނׂłB
        }

        if (result.getBundleName() == null) {
            throw new IllegalArgumentException(fMsg.getMbebmr02());
        }
        if (result.getBundleSymbolicName() == null) {
            throw new IllegalArgumentException(fMsg.getMbebmr03());
        }
        if (result.getBundleVersion() == null) {
            throw new IllegalArgumentException(fMsg.getMbebmr04());
        }

        return result;
    }

    /**
     * ^ꂽ MANIFEST.MF̂߂̓̓Xg[ }jtFXgǂݍ݂܂B
     * 
     * @param inStream
     *            MANIFEST.MFt@Cւ̓̓Xg[B
     * @return Manifesto[IuWFNgB
     * @throws IOException
     *             o͗OꍇB
     */
    private BlancoNLpackGeneratorManifest read(final InputStream inStream)
            throws IOException {
        final Manifest manifest = new Manifest(inStream);
        return read(manifest);
    }

    /**
     * w肳ꂽvOCfBNg MANIFEST.MFǂݎ܂B
     * 
     * @param inputDir
     *            vOCfBNg ( MANIFEST.MFt@C܂܂邱ƂO)
     * @return Manifesto[IuWFNgB
     * @throws IOException
     *             o͗OꍇB
     */
    public BlancoNLpackGeneratorManifest readPluginDirectory(final File inputDir)
            throws IOException {
        BlancoNLpackGeneratorManifest result = null;

        if (inputDir.exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbebmr11(inputDir
                    .getAbsolutePath()));
        }
        if (inputDir.isDirectory() == false) {
            throw new IllegalArgumentException(fMsg.getMbebmr12(inputDir
                    .getAbsolutePath()));
        }

        final File[] files = inputDir.listFiles();
        if (files != null) {
            for (int index = 0; index < files.length; index++) {
                if (files[index].isDirectory()) {
                    if (files[index].getName().equals("META-INF")) {
                        // ꂾI
                        final File[] filesMetaInf = files[index].listFiles();
                        if (filesMetaInf != null) {
                            for (int indexMeta = 0; indexMeta < filesMetaInf.length; indexMeta++) {
                                if (filesMetaInf[indexMeta].getName().equals(
                                        "MANIFEST.MF")) {
                                    // qbgI
                                    final InputStream inStream = new BufferedInputStream(
                                            new FileInputStream(
                                                    filesMetaInf[indexMeta]));

                                    try {
                                        result = read(inStream);
                                    } catch (IllegalArgumentException ex) {
                                        result = readManifestFromTargetName(inputDir
                                                .getName());
                                    }
                                    inStream.close();
                                }
                            }
                        }
                    }
                } else {
                    // fBNgȊO͏B
                }
            }
        }

        if (result == null) {
            // vOCfBNg̓ǂݎ
            // MANIFEST.MFȂꍇɂ́AfBNgƂ̌s܂B
            result = readManifestFromTargetName(inputDir.getName());
        }

        return result;
    }

    /**
     * w肳ꂽvOCjart@C MANIFEST.MFǂݎ܂B
     * 
     * @param inputFile
     *            vOCjart@C ( MANIFEST.MFt@C܂܂邱ƂO)
     * @return Manifesto[IuWFNgB
     * @throws IOException
     *             o͗OꍇB
     */
    public BlancoNLpackGeneratorManifest readPluginJar(final File inputFile)
            throws IOException {
        BlancoNLpackGeneratorManifest result = null;

        if (inputFile.exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbebmr21(inputFile
                    .getAbsolutePath()));
        }
        if (inputFile.isFile() == false) {
            throw new IllegalArgumentException(fMsg.getMbebmr22(inputFile
                    .getAbsolutePath()));
        }

        final ZipInputStream jarInStream = new ZipInputStream(
                new BufferedInputStream(new FileInputStream(inputFile)));
        try {
            for (;;) {
                final ZipEntry entry = jarInStream.getNextEntry();
                if (entry == null) {
                    break;
                }

                if (entry.isDirectory()) {
                } else {
                    if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                        try {
                            result = read(jarInStream);
                        } catch (IllegalArgumentException ex) {
                            result = readManifestFromTargetName(inputFile
                                    .getName());
                        }
                    }
                }
                jarInStream.closeEntry();
            }
        } finally {
            jarInStream.close();
        }

        if (result == null) {
            // vOCjar̓ǂݎ
            // MANIFEST.MFȂꍇɂ́At@CƂ̌s܂B
            result = readManifestFromTargetName(inputFile.getName());
        }

        return result;
    }

    /**
     * Z~RɂIvV ΂B
     * 
     * @param value
     * @return
     */
    private String getValueWithoutOption(final String value) {
        final StringTokenizer token = new StringTokenizer(value, ";");
        // Z~R؂̏ꍇɂ͑Ő󔒂B
        return token.nextToken().trim();
    }

    /**
     * ^ꂽfBNgEt@C^[Qbg𓱏o܂B
     * 
     * MANIFEST.MFt@CƂ邱ƂoȂꍇɁAȂ̃\bh𗘗p܂B
     * 
     * @param targetName
     *            vOCfBNg܂̓vOCjart@CB
     * @return }jtFXgB
     */
    private BlancoNLpackGeneratorManifest readManifestFromTargetName(
            String targetName) {
        if (targetName.endsWith(".jar")) {
            // MANIFEST.MF疼̂擾łȂ֏̍ۂɁA^[Qbg .jar ܂܂ꍇɂ͂܂B
            targetName = targetName.substring(0, targetName.length()
                    - ".jar".length());
        }

        final BlancoNLpackGeneratorManifest result = new BlancoNLpackGeneratorManifest();
        result.setBundleSymbolicName(BlancoNLpackGeneratorUtil
                .getBundleSymbolicName(targetName));
        result.setBundleVersion(BlancoNLpackGeneratorUtil
                .getBundleVersion(targetName));
        result.setBundleName(targetName);
        return result;
    }
}
