/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.manifest;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;

import blanco.commons.util.BlancoStringUtil;
import blanco.nlpack.generator.resourcebundle.BlancoNLpackGeneratorResourceBundle;
import blanco.nlpack.generator.valueobject.BlancoNLpackGeneratorManifest;

/**
 * }jtFXg ([MANIFEST.MF]t@C) 쐬NXB
 * 
 * TODO nl_fragment.properties ͕ʃNXɕׂǂ邱ƁB
 * 
 * @author IGA Tosiki
 */
public class BlancoNLpackGeneratorManifestWriter {
    /**
     * vOŗp郊\[XohB
     */
    private final BlancoNLpackGeneratorResourceBundle fBundle = new BlancoNLpackGeneratorResourceBundle();

    /**
     * }jtFXgꎮo܂B
     * 
     * @param manifest
     *            }jtFXgB
     * @param targetDir
     *            o͐ƂȂfBNgB
     * @throws IOException
     *             o͗OꍇB
     */
    public void write(final BlancoNLpackGeneratorManifest manifest,
            final File targetDir) throws IOException {
        if (targetDir.exists() == false) {
            targetDir.mkdirs();
        }

        // nl_fragment.properties óB
        writeFragmentProperties(manifest, targetDir);

        // META-INF/MANIFEST.MF óB
        {
            final File metaInfDir = new File(targetDir.getAbsolutePath()
                    + "/META-INF");
            if (metaInfDir.exists() == false) {
                metaInfDir.mkdirs();
            }

            // Kvɉčڂ̒l㏑ăZbgB
            final BlancoNLpackGeneratorManifest manifestWrk = new BlancoNLpackGeneratorManifest();
            manifestWrk.setBundleName("%nlFragmentName");
            manifestWrk.setBundleSymbolicName(manifest.getBundleSymbolicName()
                    + "." + fBundle.getSymbolicNameSuffix()
                    + " ;singleton=true");
            manifestWrk.setBundleVersion(manifest.getBundleVersion());
            manifestWrk.setBundleVendor("%nlProviderName");
            manifestWrk.setFragmentHost(manifest.getBundleSymbolicName());
            manifestWrk.setBundleLocalization("nl_fragment");
            writeManifestMfInternal(manifestWrk, new File(targetDir
                    .getAbsolutePath()
                    + "/META-INF/MANIFEST.MF"));
        }
    }

    /**
     * nl_fragment.properties o͂܂B
     * 
     * @param manifest
     *            }jtFXgB
     * @param targetDir
     *            o͐ƂȂfBNgB
     * @throws IOException
     *             o͗OꍇB
     */
    private void writeFragmentProperties(
            final BlancoNLpackGeneratorManifest manifest, final File targetDir)
            throws IOException {
        final BufferedWriter writer = new BufferedWriter(new FileWriter(
                targetDir.getAbsolutePath() + "/nl_fragment.properties"));
        writer.write("#");
        writer.newLine();

        // : voC_͏㏑Ă܂B
        writer.write("nlProviderName=" + fBundle.getManifestBundleVendor());
        writer.newLine();

        String bundleName = manifest.getBundleName();
        if (bundleName.startsWith("%")) {
            bundleName = manifest.getBundleSymbolicName();
        }

        {
            final Locale locTarget = new Locale(fBundle.getTargetLocale());
            writer.write("nlFragmentName=" + bundleName + " "
                    + locTarget.getDisplayLanguage(Locale.US) + " NLS Support");
        }

        writer.newLine();
        writer.close();
    }

    /**
     * META-INF/MANIFEST.MF o͂܂B
     * 
     * @param manifest
     *            }jtFXgB
     * @param outFile
     *            o͐t@CB
     * @throws IOException
     *             o͗OꍇB
     */
    private void writeManifestMfInternal(
            final BlancoNLpackGeneratorManifest manifest, final File outFile)
            throws IOException {

        final BufferedWriter writer = new BufferedWriter(
                new FileWriter(outFile));
        writer.write("Manifest-Version: " + manifest.getManifestVersion());
        writer.newLine();

        writer.write("Bundle-Name: " + manifest.getBundleName());
        writer.newLine();

        if (BlancoStringUtil.null2Blank(manifest.getBundleSymbolicName())
                .length() > 0) {
            writer.write("Bundle-SymbolicName: "
                    + manifest.getBundleSymbolicName());
            writer.newLine();
        }

        if (BlancoStringUtil.null2Blank(manifest.getBundleVersion()).length() > 0) {
            writer.write("Bundle-Version: " + manifest.getBundleVersion());
            writer.newLine();
        }

        if (BlancoStringUtil.null2Blank(manifest.getBundleVendor()).length() > 0) {
            writer.write("Bundle-Vendor: " + manifest.getBundleVendor());
            writer.newLine();
        }

        if (BlancoStringUtil.null2Blank(manifest.getFragmentHost()).length() > 0) {
            writer.write("Fragment-Host: " + manifest.getFragmentHost());
            writer.newLine();
        }

        if (BlancoStringUtil.null2Blank(manifest.getBundleLocalization())
                .length() > 0) {
            writer.write("Bundle-Localization: "
                    + manifest.getBundleLocalization());
            writer.newLine();
        }

        writer.close();
    }
}
