/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.client.javasvn;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.ICredentialsPrompt;
import org.polarion.team.svn.core.client.BlameCallback;
import org.polarion.team.svn.core.client.ChangePath;
import org.polarion.team.svn.core.client.ClientWrapperAuthenticationException;
import org.polarion.team.svn.core.client.ClientWrapperCancelException;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.client.ClientWrapperUnresolvedConflictException;
import org.polarion.team.svn.core.client.DirEntry;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.utility.Notify2Composite;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.tigris.subversion.javahl.ClientAuthenticationException;
import org.tigris.subversion.javahl.ClientCancelException;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.ClientExceptionEx;
import org.tigris.subversion.javahl.ConversionUtility;
import org.tigris.subversion.javahl.DirEntryEx;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.client.IProgressMonitor;
import org.tmatesoft.svn.core.client.SVNClientEx;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordProxy;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordSSH;
import org.tmatesoft.svn.core.javahl.PromptUserPasswordSSL;

public class JavaSVNClientProxy
implements ISVNClientWrapper {
    protected SVNClientEx client = new SVNClientEx();
    protected ICredentialsPrompt prompt;
    protected Notify2Composite composite = new Notify2Composite();
    protected Notify2 installedNotify2;

    public JavaSVNClientProxy() {
        this.client.notification2(ConversionUtility.convert((Notify2)this.composite));
    }

    public String getConfigDirectory() throws ClientWrapperException {
        try {
            return this.client.getConfigDirectory();
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    public void dispose() {
        this.client.dispose();
    }

    public void add(String path, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.add(path, recurse, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, BlameCallback callback, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.blame(path, ConversionUtility.convert(pegRevision), ConversionUtility.convert(revisionStart), ConversionUtility.convert(revisionEnd), ConversionUtility.convert(callback));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    public long checkout(String moduleName, String destPath, Revision revision, Revision pegRevision, boolean recurse, boolean ignoreExternals, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return this.client.checkout(moduleName, destPath, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), recurse, ignoreExternals, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return 0L;
        }
    }

    public void cleanup(String path, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.cleanup(path, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public long[] commit(String[] path, String message, boolean recurse, boolean noUnlock, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return this.client.commit(path, message, recurse, noUnlock, true, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(String srcPath, String destPath, String message, Revision revision, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.copy(srcPath, destPath, message, ConversionUtility.convert(revision));
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void diff(String target1, Revision revision1, Revision peg1, String target2, Revision revision2, Revision peg2, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean diffUnversioned, boolean relativePath, ISVNProgressMonitor monitor) throws ClientWrapperException {
        if (this.usePegSignature(target1, revision1, peg1, target2, revision2, peg2)) {
            ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
            try {
                try {
                    this.composite.add((Notify2)wrapper);
                    wrapper.start();
                    this.client.diff(target1, ConversionUtility.convert(peg1), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), outFileName, recurse, ignoreAncestry, noDiffDeleted, force);
                }
                catch (ClientException ex) {
                    this.handleClientException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                wrapper.interrupt();
                this.composite.remove((Notify2)wrapper);
                throw throwable;
            }
            {
                Object var17_20 = null;
                wrapper.interrupt();
                this.composite.remove((Notify2)wrapper);
                return;
            }
        }
        try {
            this.client.diff(target1, ConversionUtility.convert(revision1), target2, ConversionUtility.convert(revision2), outFileName, recurse, ignoreAncestry, noDiffDeleted, force, diffUnversioned, relativePath, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
            return;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public Status[] diffStatus(String url1, Revision pegRevision1, Revision revision1, String url2, Revision pegRevision2, Revision revision2, boolean recurse, boolean ignoreAncestry, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return ConversionUtility.convert(this.client.diffStatus(url1, ConversionUtility.convert(pegRevision1), ConversionUtility.convert(revision1), url2, ConversionUtility.convert(pegRevision2), ConversionUtility.convert(revision2), recurse, ignoreAncestry, (IProgressMonitor)new ProgressMonitorWrapper(monitor)));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, boolean recurse, String nativeEOL, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return this.client.doExport(srcPath, destPath, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), force, ignoreExternals, recurse, nativeEOL, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return 0L;
        }
    }

    public void doImport(String path, String url, String message, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.doImport(path, url, message, recurse, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public long doSwitch(String path, String url, Revision revision, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return this.client.doSwitch(path, url, ConversionUtility.convert(revision), recurse, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return 0L;
        }
    }

    public byte[] fileContent(String path, Revision revision, Revision pegRevision, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return this.client.fileContent(path, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void streamFileContent(String path, Revision revision, Revision pegRevision, int bufferSize, OutputStream stream, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.streamFileContent(path, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), bufferSize, stream);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    public Notify2 getNotification2() {
        return this.installedNotify2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Info2[] info2(String pathOrUrl, Revision revision, Revision pegRevision, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            Info2[] info2Array;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                info2Array = ConversionUtility.convert(this.client.info2(pathOrUrl, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), recurse));
                Object var8_8 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return info2Array;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    public boolean isCommitMissingFiles() {
        return this.client.isCommitMissingFile();
    }

    public boolean isCredentialsCacheEnabled() {
        return this.client.isCredentialsCacheEnabled();
    }

    public boolean isReportRevisionChange() {
        return this.client.isReportRevisionChange();
    }

    public boolean isSSLCertificateCacheEnabled() {
        return this.client.isSSLCertificateCacheEnabled();
    }

    public boolean isTouchUnresolved() {
        return this.client.isTouchUnresolved();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DirEntry[] list(String url, Revision revision, Revision pegRevision, boolean recurse, boolean fetchLocks, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            DirEntry[] dirEntryArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                DirEntryEx[] entries = this.client.list(url, ConversionUtility.convert(revision), ConversionUtility.convert(pegRevision), recurse, fetchLocks);
                DirEntry[] retVal = new DirEntry[entries.length];
                int i = 0;
                while (true) {
                    if (i >= entries.length) {
                        dirEntryArray = retVal;
                        Object var11_13 = null;
                        break;
                    }
                    retVal[i] = new DirEntry(entries[i].getLastChanged(), entries[i].getLastChangedRevisionNumber(), entries[i].getHasProps(), entries[i].getLastAuthor(), entries[i].getNodeKind(), entries[i].getSize(), entries[i].getPath(), ConversionUtility.convert(entries[i].getLock()));
                    ++i;
                }
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return dirEntryArray;
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    public void lock(String[] path, String comment, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.lock(path, comment, force, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public LogMessage[] logMessages(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath, long limit, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return ConversionUtility.convert(this.client.logMessages(path, ConversionUtility.convert(pegRevision), ConversionUtility.convert(revisionStart), ConversionUtility.convert(revisionEnd), stopOnCopy, discoverPath, limit, (IProgressMonitor)new ProgressMonitorWrapper(monitor)));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    public void merge(String path, Revision pegRevision, Revision revision1, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.merge(path, ConversionUtility.convert(pegRevision), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), localPath, force, recurse, ignoreAncestry, dryRun, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.merge(path1, ConversionUtility.convert(revision1), path2, ConversionUtility.convert(revision2), localPath, force, recurse, ignoreAncestry, dryRun, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public Status[] merge(String url, Revision peg, Revision from, Revision to, String mergePath, Status[] mergeStatus, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            int i = 0;
            while (i < mergeStatus.length && !monitor.isActivityCancelled()) {
                if (mergeStatus[i].textStatus == 4) {
                    this.client.remove(new String[]{mergeStatus[i].path}, null, force, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
                } else if (mergeStatus[i].textStatus == 3 && !new File(mergeStatus[i].path).exists()) {
                    this.client.copy(mergeStatus[i].url, mergeStatus[i].path, null, ConversionUtility.convert(to));
                } else {
                    this.client.merge(mergeStatus[i].url, ConversionUtility.convert(peg), ConversionUtility.convert(from), ConversionUtility.convert(to), mergeStatus[i].path, force, false, false, false, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
                }
                ++i;
            }
            return null;
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    public Status[] mergeStatus(String url, Revision peg, Revision from, Revision to, String path, Revision lastMerged, boolean recurse, boolean ignoreAncestry, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            final ArrayList tmp = new ArrayList();
            this.client.merge(url, ConversionUtility.convert(peg), ConversionUtility.convert(from), ConversionUtility.convert(to), path, true, recurse, ignoreAncestry, true, (IProgressMonitor)new ProgressMonitorWrapper(monitor){

                public void progress(int current, int total, IProgressMonitor.ItemState state) {
                    super.progress(current, total, state);
                    tmp.add(state);
                }
            });
            ArrayList<Status> retVal = new ArrayList<Status>();
            int i = 0;
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                IProgressMonitor.ItemState state = (IProgressMonitor.ItemState)it.next();
                String tUrl = SVNUtility.normalizeURL((String)(String.valueOf(url) + state.path.substring(path.length())));
                int cState = 0;
                int pState = 0;
                if (state.action == 9) {
                    cState = 3;
                } else if (state.action == 8) {
                    cState = 4;
                } else if (state.action == 10) {
                    int n = pState = state.propState == 5 ? 2 : 0;
                    int n2 = state.contentState == 5 || state.contentState == 6 ? 2 : (cState = state.contentState == 7 || state.contentState == 8 ? 9 : 0);
                }
                if (cState != 0 || pState != 0) {
                    LogMessage[] msgs;
                    long revision = -1L;
                    long date = 0L;
                    String author = null;
                    String message = null;
                    if (cState != 4) {
                        msgs = this.logMessages(tUrl, peg, to, from, true, false, 1L, monitor);
                        if (msgs != null && msgs.length > 0) {
                            revision = msgs[0].revision;
                            date = msgs[0].date;
                            author = msgs[0].author;
                            message = msgs[0].message;
                        }
                    } else {
                        msgs = this.logMessages(new Path(tUrl).removeLastSegments(1).toString(), peg, to, from, true, true, 0L, monitor);
                        if (msgs != null) {
                            int j = 0;
                            while (j < msgs.length) {
                                ChangePath[] paths = msgs[j].changedPaths;
                                if (paths != null) {
                                    int k = 0;
                                    while (k < paths.length) {
                                        if (paths[k] != null && tUrl.endsWith(paths[k].path)) {
                                            revision = msgs[0].revision;
                                            date = msgs[0].date;
                                            author = msgs[0].author;
                                            message = msgs[0].message;
                                            j = msgs.length;
                                            break;
                                        }
                                        ++k;
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                    retVal.add(new Status(state.path, tUrl, state.kind, revision, revision, date, author, cState, pState, 0, 0, false, false, null, null, null, null, -1L, false, null, null, message, 0L, null, -1L, 0L, state.kind, null, null));
                }
                ++i;
            }
            return retVal.toArray(new Status[retVal.size()]);
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mkdir(String[] path, String message, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.mkdir(path, message);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(String srcPath, String dstPath, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.move(srcPath, dstPath, force);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(String srcPath, String destPath, String message, Revision revision, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.move(srcPath, destPath, message, ConversionUtility.convert(revision), force);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    public void notification2(Notify2 notify) {
        if (this.installedNotify2 != null) {
            this.composite.remove(this.installedNotify2);
        }
        this.installedNotify2 = notify;
        if (this.installedNotify2 != null) {
            this.composite.add(this.installedNotify2);
        }
    }

    public void password(String password) {
        this.client.password(password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertyData[] properties(String path, Revision revision, Revision peg, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            PropertyData[] propertyDataArray;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                propertyDataArray = ConversionUtility.convert(this.client.properties(path, ConversionUtility.convert(revision), ConversionUtility.convert(peg)));
                Object var7_7 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return propertyDataArray;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertyData propertyGet(String path, String name, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            PropertyData propertyData;
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                propertyData = ConversionUtility.convert(this.client.propertyGet(path, name));
                Object var6_6 = null;
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            return propertyData;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyRemove(String path, String name, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.propertyRemove(path, name, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertySet(String path, String name, byte[] value, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.propertySet(path, name, value, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertySet(String path, String name, String value, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.propertySet(path, name, value, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolved(String path, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        ProgressMonitorWrapperThread wrapper = new ProgressMonitorWrapperThread(monitor);
        try {
            try {
                this.composite.add((Notify2)wrapper);
                wrapper.start();
                this.client.resolved(path, recurse);
            }
            catch (ClientException ex) {
                this.handleClientException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            wrapper.interrupt();
            this.composite.remove((Notify2)wrapper);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        wrapper.interrupt();
        this.composite.remove((Notify2)wrapper);
    }

    public void relocate(String from, String to, String path, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.relocate(from, to, path, recurse, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public void remove(String[] path, String message, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.remove(path, message, force, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public void revert(String path, boolean recurse, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.revert(path, recurse, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        this.client.setClientSSLCertificate(certPath, passphrase);
    }

    public void setCommitMissingFiles(boolean commitMissingFiles) {
        this.client.setCommitMissedFiles(commitMissingFiles);
    }

    public void setCredentialsCacheEnabled(boolean cacheCredentials) {
        this.client.setCredentialsCacheEnabled(cacheCredentials);
    }

    public void setPrompt(ICredentialsPrompt prompt) {
        RepositoryInfoPrompt repositoryInfoPrompt;
        if (prompt == null) {
            repositoryInfoPrompt = null;
        } else {
            this.prompt = prompt;
            RepositoryInfoPrompt repositoryInfoPrompt2 = new RepositoryInfoPrompt(this.prompt);
            repositoryInfoPrompt = repositoryInfoPrompt2;
        }
        this.client.setPrompt((PromptUserPassword)repositoryInfoPrompt);
    }

    public ICredentialsPrompt getPrompt() {
        return this.prompt;
    }

    public void setProxy(String host, int port, String userName, String password) {
        this.client.setProxy(host, port, userName, password);
    }

    public void setReportRevisionChange(boolean report) {
        this.client.setReportRevisionChange(report);
    }

    public void setSSHCredentials(String userName, String privateKeyPath, String passphrase, int port) {
        this.client.setSSHCredentials(userName, privateKeyPath, passphrase, port);
    }

    public void setSSHCredentials(String userName, String password, int port) {
        this.client.setSSHCredentials(userName, password, port);
    }

    public void setSSLCertificateCacheEnabled(boolean enabled) {
        this.client.setSSLCertificateCacheEnabled(enabled);
    }

    public void setTouchUnresolved(boolean touchUnresolved) {
        this.client.setTouchUnresolved(touchUnresolved);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return ConversionUtility.convert(this.client.status(path, descend, onServer, getAll, noIgnore, (IProgressMonitor)new ProgressMonitorWrapper(monitor)));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore, boolean collectParentExternals, boolean ignoreExternals, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return ConversionUtility.convert(this.client.status(path, descend, onServer, getAll, noIgnore, collectParentExternals, ignoreExternals, (IProgressMonitor)new ProgressMonitorWrapper(monitor)));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    public void unlock(String[] path, boolean force, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            this.client.unlock(path, force, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
        }
    }

    public long[] update(String[] path, Revision revision, boolean recurse, boolean ignoreExternals, ISVNProgressMonitor monitor) throws ClientWrapperException {
        try {
            return this.client.update(path, ConversionUtility.convert(revision), recurse, ignoreExternals, (IProgressMonitor)new ProgressMonitorWrapper(monitor));
        }
        catch (ClientException ex) {
            this.handleClientException(ex);
            return null;
        }
    }

    public void username(String username) {
        this.client.username(username);
    }

    protected void handleClientException(ClientException ex) throws ClientWrapperException {
        if (ex instanceof ClientCancelException) {
            throw new ClientWrapperCancelException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ClientAuthenticationException) {
            throw new ClientWrapperAuthenticationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ClientExceptionEx && this.findConflict((ClientExceptionEx)ex)) {
            throw new ClientWrapperUnresolvedConflictException(ex.getMessage(), (Throwable)ex);
        }
        boolean runtime = false;
        if (ex instanceof ClientExceptionEx) {
            Throwable cause = ex.getCause();
            runtime = cause != null && cause instanceof RuntimeException;
        }
        throw new ClientWrapperException(ex.getMessage(), ex.getAprError(), (Throwable)ex, runtime);
    }

    protected boolean findConflict(ClientExceptionEx t) {
        if (this.findConflict(t.getErrorMessage())) {
            return true;
        }
        if (t.getNestedExceptions() != null) {
            ClientExceptionEx[] nestedExceptions = t.getNestedExceptions();
            int i = 0;
            while (i < nestedExceptions.length) {
                SVNErrorMessage errorNest = nestedExceptions[i].getErrorMessage();
                if (this.findConflict(errorNest)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean findConflict(SVNErrorMessage error) {
        while (error != null) {
            if (error.getErrorCode() == SVNErrorCode.FS_CONFLICT || error.getErrorCode() == SVNErrorCode.FS_TXN_OUT_OF_DATE) {
                return true;
            }
            error = error.getChildErrorMessage();
        }
        return false;
    }

    protected boolean usePegSignature(String target1, Revision revision1, Revision peg1, String target2, Revision revision2, Revision peg2) {
        int kind1 = revision1.getKind();
        int kind2 = revision2.getKind();
        if (!(kind1 != 5 && kind1 != 6 || kind2 != 5 && kind2 != 6)) {
            return false;
        }
        return target1.equals(target2) && (peg1 == peg2 || peg1 != null && peg1.equals((Object)peg2));
    }

    protected class RepositoryInfoPrompt
    implements PromptUserPasswordSSL,
    PromptUserPasswordSSH,
    PromptUserPasswordProxy {
        protected ICredentialsPrompt prompt;

        public RepositoryInfoPrompt(ICredentialsPrompt prompt) {
            this.prompt = prompt;
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return this.prompt(realm, username);
        }

        public boolean prompt(String realm, String username) {
            return this.prompt.prompt(null, realm);
        }

        public boolean promptSSL(String realm, boolean maySave) {
            return this.prompt.promptSSL(null, realm);
        }

        public boolean promptSSH(String realm, String username, int sshPort, boolean maySave) {
            return this.prompt.promptSSH(null, realm);
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return this.prompt.askTrustSSLServer(null, info, allowPermanently);
        }

        public String getUsername() {
            return this.prompt.getUsername();
        }

        public String getPassword() {
            return this.prompt.getPassword();
        }

        public String getSSHPrivateKeyPath() {
            return this.prompt.getSSHPrivateKeyPath();
        }

        public String getSSHPrivateKeyPassphrase() {
            return this.prompt.getSSHPrivateKeyPassphrase();
        }

        public int getSSHPort() {
            return this.prompt.getSSHPort();
        }

        public String getSSLClientCertPath() {
            return this.prompt.getSSLClientCertPath();
        }

        public String getSSLClientCertPassword() {
            return this.prompt.getSSLClientCertPassword();
        }

        public boolean promptProxy(String url, boolean maySave) {
            return this.prompt.promptProxy(null);
        }

        public String getProxyHost() {
            return this.prompt.getProxyHost();
        }

        public int getProxyPort() {
            return this.prompt.getProxyPort();
        }

        public String getProxyUserName() {
            return this.prompt.getProxyUserName();
        }

        public String getProxyPassword() {
            return this.prompt.getProxyPassword();
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return false;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            return null;
        }

        public String askQuestion(String realm, String question, boolean showAnswer) {
            return null;
        }

        public boolean userAllowedSave() {
            return false;
        }
    }

    protected class ProgressMonitorWrapper
    implements IProgressMonitor {
        protected ISVNProgressMonitor monitor;

        public ProgressMonitorWrapper(ISVNProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean isActivityCancelled() {
            return this.monitor.isActivityCancelled();
        }

        public void progress(int current, int total, IProgressMonitor.ItemState state) {
            this.monitor.progress(current, total, state == null ? null : new ISVNProgressMonitor.ItemState(state.path, state.action, state.kind, state.mimeType, state.contentState, state.propState, state.lockState, state.revision));
        }
    }

    protected class ProgressMonitorWrapperThread
    extends Thread
    implements Notify2 {
        protected ISVNProgressMonitor monitor;
        protected int current;
        protected String errorMessage;

        public ProgressMonitorWrapperThread(ISVNProgressMonitor monitor) {
            this.monitor = monitor;
            this.current = 0;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void onNotify(NotifyInformation arg0) {
            if (arg0.errMsg != null) {
                this.errorMessage = this.errorMessage == null ? arg0.errMsg : String.valueOf(this.errorMessage) + "\n\n" + arg0.errMsg;
            } else {
                this.monitor.progress(this.current++, -1, new ISVNProgressMonitor.ItemState(arg0.path, arg0.action, arg0.kind, arg0.mimeType, arg0.contentState, arg0.propState, arg0.lockState, arg0.revision));
            }
        }

        public void run() {
            try {
                while (!this.monitor.isActivityCancelled() && !this.isInterrupted()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {}
            if (this.monitor.isActivityCancelled()) {
                try {
                    JavaSVNClientProxy.this.client.cancelOperation();
                }
                catch (Exception exception) {}
            }
        }
    }
}

