/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class ResourceChangeListener
implements IResourceChangeListener,
ISaveParticipant {
    public static int INTERESTING_CHANGES = 323584;

    public void resourceChanged(final IResourceChangeEvent event) {
        ProgressMonitorUtility.doTaskScheduledDefault(new AbstractNonLockingOperation("Operation.ResourcesChanged"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                HashSet<IResource> modified = new HashSet<IResource>();
                event.getDelta().accept(new IResourceDeltaVisitor(this, modified){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Set val$modified;
                    {
                        this.this$1 = var1_1;
                        this.val$modified = set;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 8) {
                            return true;
                        }
                        if (!FileUtility.isConnected(resource)) {
                            return false;
                        }
                        if (FileUtility.isSVNInternals(resource)) {
                            IContainer parent = resource.getParent();
                            this.val$modified.add(parent);
                            if (parent.exists()) {
                                this.val$modified.addAll(Arrays.asList(parent.members()));
                            }
                            return false;
                        }
                        if (delta.getKind() == 1 || delta.getKind() == 2) {
                            this.val$modified.add(resource);
                        }
                        if (delta.getKind() == 4) {
                            int flags = delta.getFlags();
                            if (resource instanceof IContainer && (flags & INTERESTING_CHANGES) != 0 || resource instanceof IFile && (flags & (INTERESTING_CHANGES | 0x100)) != 0) {
                                this.val$modified.add(resource);
                            }
                        }
                        return true;
                    }
                }, 2);
                IResource[] resources = modified.toArray(new IResource[modified.size()]);
                SVNRemoteStorage.instance().refreshLocalResources(resources, 2);
                modified.addAll(Arrays.asList(FileUtility.getPathNodes(resources)));
                resources = modified.toArray(new IResource[modified.size()]);
                SVNRemoteStorage.instance().fireResourceStatesChangedEvent(new ResourceStatesChangedEvent(resources, 0));
            }
        });
    }

    public void handleInitialWorkspaceDelta() throws CoreException {
        ISavedState ss = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)SVNTeamPlugin.instance(), (ISaveParticipant)this);
        if (ss != null) {
            ss.processResourceChangeEvents((IResourceChangeListener)this);
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }
}

