/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.AddToSVNWithPropertiesOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.refactor.CopyResourceOperation;
import org.polarion.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.polarion.team.svn.core.operation.local.refactor.MoveResourceOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class SVNTeamMoveDeleteHook
implements IMoveDeleteHook {
    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        return this.doDelete(tree, (IResource)file, monitor);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        return this.doDelete(tree, (IResource)folder, monitor);
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        return this.doMove(tree, (IResource)source, (IResource)destination, monitor);
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        return this.doMove(tree, (IResource)source, (IResource)destination, monitor);
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    protected boolean doMove(IResourceTree tree, IResource source, IResource destination, IProgressMonitor monitor) {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        ILocalResource local = storage.asLocalResource(source);
        if (local == null || IStateFilter.SF_NOTEXISTS.accept(source, local.getStatus(), local.getChangeMask()) || IStateFilter.SF_NONVERSIONED.accept(source, local.getStatus(), local.getChangeMask()) || IStateFilter.SF_OBSTRUCTED.accept(source, local.getStatus(), local.getChangeMask())) {
            return FileUtility.isSVNInternals(source);
        }
        local = storage.asLocalResource((IResource)destination.getParent());
        if (local == null || IStateFilter.SF_LINKED.accept(destination, local.getStatus(), local.getChangeMask()) || IStateFilter.SF_OBSTRUCTED.accept(destination, local.getStatus(), local.getChangeMask())) {
            return false;
        }
        MoveResourceOperation moveOp = new MoveResourceOperation(source, destination);
        CompositeOperation op = new CompositeOperation(moveOp.getId());
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(new IResource[]{source, destination});
        op.add(saveOp);
        if (!moveOp.isAllowed()) {
            CopyResourceOperation copyLocalResourceOp = new CopyResourceOperation(source, destination);
            op.add(copyLocalResourceOp);
            op.add(new DeleteResourceOperation(source), new IActionOperation[]{copyLocalResourceOp});
            op.add(new RestoreProjectMetaOperation(saveOp));
            op.add(new RefreshResourcesOperation(new IResource[]{source, destination}, 2, RefreshResourcesOperation.REFRESH_ALL));
        } else if (IStateFilter.SF_NONVERSIONED.accept(destination, local.getStatus(), local.getChangeMask())) {
            IResource[] scheduledForAddition = FileUtility.getOperableParents(new IResource[]{destination}, IStateFilter.SF_NONVERSIONED, true);
            AddToSVNWithPropertiesOperation addToSVNOp = new AddToSVNWithPropertiesOperation(scheduledForAddition, false);
            op.add(addToSVNOp);
            op.add(moveOp, new IActionOperation[]{addToSVNOp});
            op.add(new RestoreProjectMetaOperation(saveOp));
            ArrayList<IResource> fullSet = new ArrayList<IResource>(Arrays.asList(scheduledForAddition));
            fullSet.addAll(Arrays.asList(source, destination));
            op.add(new RefreshResourcesOperation(fullSet.toArray(new IResource[fullSet.size()]), 2, RefreshResourcesOperation.REFRESH_ALL));
        } else {
            op.add(moveOp);
            op.add(new RestoreProjectMetaOperation(saveOp));
            op.add(new RefreshResourcesOperation(new IResource[]{source, destination}, 2, RefreshResourcesOperation.REFRESH_ALL));
        }
        ProgressMonitorUtility.doTaskExternal(op, monitor);
        return true;
    }

    protected boolean doDelete(IResourceTree tree, IResource resource, IProgressMonitor monitor) {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        if (local == null || IStateFilter.SF_NOTEXISTS.accept(resource, local.getStatus(), local.getChangeMask()) || IStateFilter.SF_NONVERSIONED.accept(resource, local.getStatus(), local.getChangeMask())) {
            return FileUtility.isSVNInternals(resource);
        }
        DeleteResourceOperation mainOp = new DeleteResourceOperation(resource);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(new IResource[]{resource});
        op.add(saveOp);
        op.add(mainOp);
        op.add(new RestoreProjectMetaOperation(saveOp));
        op.add(new RefreshResourcesOperation(new IResource[]{resource}, 2, RefreshResourcesOperation.REFRESH_ALL));
        ProgressMonitorUtility.doTaskExternal(op, monitor);
        return true;
    }
}

