/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.history;

import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.history.SVNLocalResourceRevision;
import org.polarion.team.svn.core.history.SVNRemoteResourceRevision;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;

public class SVNResourceHistory
extends FileHistory {
    protected static IFileRevision[] EMPTY = new IFileRevision[0];
    protected ILocalResource local;
    protected IRepositoryResource remote;
    protected LogMessage[] msgs;
    protected boolean full;

    public SVNResourceHistory(ILocalResource local, IRepositoryResource remote, LogMessage[] msgs, boolean full) {
        this.local = local;
        this.remote = remote;
        this.msgs = msgs;
        this.full = full;
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        int idx = this.getRevisionIdx(revision.getContentIdentifier());
        if (idx != -1 && idx < this.msgs.length - 1) {
            return new IFileRevision[]{new SVNRemoteResourceRevision(this.remote, this.msgs[idx + 1])};
        }
        return EMPTY;
    }

    public IFileRevision getFileRevision(String id) {
        if (Revision.WORKING.toString().equals(id)) {
            return new SVNLocalResourceRevision(this.local, Revision.WORKING);
        }
        if (Revision.BASE.toString().equals(id)) {
            return new SVNLocalResourceRevision(this.local, Revision.BASE);
        }
        if (Revision.HEAD.toString().equals(id)) {
            return this.full ? new SVNRemoteResourceRevision(this.remote, this.msgs[0]) : null;
        }
        if (Revision.START.toString().equals(id)) {
            return this.full ? new SVNRemoteResourceRevision(this.remote, this.msgs[this.msgs.length - 1]) : null;
        }
        if (Revision.PREVIOUS.toString().equals(id)) {
            int idx = this.getRevisionIdx(this.local.getRevision());
            return idx != -1 && idx < this.msgs.length - 1 ? new SVNRemoteResourceRevision(this.remote, this.msgs[idx + 1]) : null;
        }
        if (Revision.COMMITTED.toString().equals(id)) {
            int idx = this.getRevisionIdx(this.local.getRevision());
            return idx != -1 ? new SVNRemoteResourceRevision(this.remote, this.msgs[idx]) : null;
        }
        int idx = this.getRevisionIdx(id);
        if (idx != -1) {
            return new SVNRemoteResourceRevision(this.remote, this.msgs[idx]);
        }
        return null;
    }

    public IFileRevision[] getFileRevisions() {
        IFileRevision[] revs = new IFileRevision[this.msgs.length];
        int i = 0;
        while (i < this.msgs.length) {
            revs[i] = new SVNRemoteResourceRevision(this.remote, this.msgs[i]);
            ++i;
        }
        return revs;
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        int idx = this.getRevisionIdx(revision.getContentIdentifier());
        if (idx > 0) {
            return new IFileRevision[]{new SVNRemoteResourceRevision(this.remote, this.msgs[idx - 1])};
        }
        return EMPTY;
    }

    protected int getRevisionIdx(String id) {
        long revision;
        try {
            revision = Long.parseLong(id);
        }
        catch (Exception exception) {
            return -1;
        }
        return this.getRevisionIdx(revision);
    }

    protected int getRevisionIdx(long revision) {
        int i = 0;
        while (i < this.msgs.length) {
            if (this.msgs[i].revision == revision) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

