/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ClientWrapperCancelException;
import org.polarion.team.svn.core.operation.ActivityCancelledException;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IConsoleStream;

public class LoggedOperation
implements IActionOperation {
    protected IActionOperation op;

    public LoggedOperation(IActionOperation op) {
        this.op = op;
    }

    public final IActionOperation run(IProgressMonitor monitor) {
        IStatus status = this.op.run(monitor).getStatus();
        if (status.getSeverity() != 0) {
            this.handleError(status);
        }
        return this.op;
    }

    public IConsoleStream getConsoleStream() {
        return this.op.getConsoleStream();
    }

    public void setConsoleStream(IConsoleStream stream) {
        this.op.setConsoleStream(stream);
    }

    public ISchedulingRule getSchedulingRule() {
        return this.op.getSchedulingRule();
    }

    public String getOperationName() {
        return this.op.getOperationName();
    }

    public String getId() {
        return this.op.getId();
    }

    public final IStatus getStatus() {
        return this.op.getStatus();
    }

    public int getExecutionState() {
        return this.op.getExecutionState();
    }

    public static void reportError(String where, Throwable t) {
        String errMessage = SVNTeamPlugin.instance().getResource("Operation.Error.LogHeader");
        MultiStatus status = new MultiStatus("org.polarion.team.svn.core.svnnature", 0, MessageFormat.format(errMessage, where), null);
        Status st = new Status(4, "org.polarion.team.svn.core.svnnature", 0, String.valueOf(status.getMessage()) + ": " + t.getMessage(), t);
        status.merge((IStatus)st);
        LoggedOperation.logError((IStatus)status);
    }

    protected void handleError(IStatus errorStatus) {
        if (!errorStatus.isMultiStatus()) {
            Throwable ex = errorStatus.getException();
            if (!(ex instanceof ClientWrapperCancelException) && !(ex instanceof ActivityCancelledException)) {
                LoggedOperation.logError(errorStatus);
            }
            return;
        }
        IStatus[] children = errorStatus.getChildren();
        ArrayList<IStatus> statusesWithoutCancel = new ArrayList<IStatus>();
        int i = 0;
        while (i < children.length) {
            Throwable exception = children[i].getException();
            if (!(exception instanceof ClientWrapperCancelException) && !(exception instanceof ActivityCancelledException)) {
                statusesWithoutCancel.add(children[i]);
            }
            ++i;
        }
        if (statusesWithoutCancel.size() > 0) {
            MultiStatus newStatus = new MultiStatus(errorStatus.getPlugin(), errorStatus.getCode(), statusesWithoutCancel.toArray(new IStatus[statusesWithoutCancel.size()]), errorStatus.getMessage(), errorStatus.getException());
            LoggedOperation.logError((IStatus)newStatus);
        }
    }

    protected static void logError(IStatus errorStatus) {
        SVNTeamPlugin.instance().getLog().log(errorStatus);
    }
}

