/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;

public class AddToSVNIgnoreOperation
extends AbstractFileOperation {
    protected int ignoreType;
    protected String pattern;

    public AddToSVNIgnoreOperation(File[] files, int ignoreType, String pattern) {
        super("Operation.AddToSVNIgnoreFile", files);
        this.ignoreType = ignoreType;
        this.pattern = pattern;
    }

    public AddToSVNIgnoreOperation(IFileProvider provider, int ignoreType, String pattern) {
        super("Operation.AddToSVNIgnoreFile", provider);
        this.ignoreType = ignoreType;
        this.pattern = pattern;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    AddToSVNIgnoreOperation.this.handleResource(current);
                }
            }, monitor, files.length);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleResource(File current) throws Exception {
        File parent = current.getParentFile();
        if (parent == null) {
            return;
        }
        IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(parent, false);
        IRepositoryLocation location = remote.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            org.polarion.team.svn.core.operation.local.AddToSVNIgnoreOperation.changeIgnoreProperty(proxy, this.ignoreType, this.pattern, parent.getAbsolutePath(), current.getName());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var6_8 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }
}

