/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class CheckoutAsOperation
extends AbstractFileOperation {
    protected IRepositoryResource resource;
    protected boolean recursive;
    protected boolean ignoreExternals;
    protected boolean override;

    public CheckoutAsOperation(File to, IRepositoryResource resource, boolean recursive, boolean ignoreExternals, boolean override) {
        super("Operation.CheckoutAsFile", new File[]{to});
        this.resource = resource;
        this.recursive = recursive;
        this.ignoreExternals = ignoreExternals;
        this.override = override;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File to = this.operableData()[0];
        if (this.override) {
            FileUtility.deleteRecursive(to, monitor);
        }
        to.mkdirs();
        IRepositoryLocation location = this.resource.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            String path = to.getAbsolutePath();
            this.writeToConsole(0, "svn checkout \"" + this.resource.getUrl() + "@" + this.resource.getPegRevision() + "\" -r " + this.resource.getSelectedRevision() + (this.recursive ? "" : " -N") + " --ignore-externals \"" + FileUtility.normalizePath(path) + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.checkout(SVNUtility.encodeURL(this.resource.getUrl()), path, this.resource.getSelectedRevision(), this.resource.getPegRevision(), this.recursive, this.ignoreExternals, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var6_8 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }
}

